/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The <code>ListRecommendations</code> filter type. This can be one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>TYPE</code> – The recommendation type, with values like <code>DKIM</code>, <code>SPF</code>, <code>DMARC</code>
 * or <code>BIMI</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>IMPACT</code> – The recommendation impact, with values like <code>HIGH</code> or <code>LOW</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>STATUS</code> – The recommendation status, with values like <code>OPEN</code> or <code>FIXED</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>RESOURCE_ARN</code> – The resource affected by the recommendation, with values like
 * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public enum ListRecommendationsFilterKey {
    TYPE("TYPE"),

    IMPACT("IMPACT"),

    STATUS("STATUS"),

    RESOURCE_ARN("RESOURCE_ARN"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ListRecommendationsFilterKey> VALUE_MAP = EnumUtils.uniqueIndex(
            ListRecommendationsFilterKey.class, ListRecommendationsFilterKey::toString);

    private final String value;

    private ListRecommendationsFilterKey(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ListRecommendationsFilterKey corresponding to the value
     */
    public static ListRecommendationsFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ListRecommendationsFilterKey}s
     */
    public static Set<ListRecommendationsFilterKey> knownValues() {
        Set<ListRecommendationsFilterKey> knownValues = EnumSet.allOf(ListRecommendationsFilterKey.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
