/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the destination of the export job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportDestination.Builder, ExportDestination> {
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(ExportDestination::dataFormatAsString)).setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Url")
            .getter(getter(ExportDestination::s3Url)).setter(setter(Builder::s3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FORMAT_FIELD,
            S3_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataFormat;

    private final String s3Url;

    private ExportDestination(BuilderImpl builder) {
        this.dataFormat = builder.dataFormat;
        this.s3Url = builder.s3Url;
    }

    /**
     * <p>
     * The data format of the final export job file, can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CSV</code> - A comma-separated values file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JSON</code> - A Json file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the final export job file, can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CSV</code> - A comma-separated values file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JSON</code> - A Json file.
     *         </p>
     *         </li>
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The data format of the final export job file, can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CSV</code> - A comma-separated values file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>JSON</code> - A Json file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The data format of the final export job file, can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CSV</code> - A comma-separated values file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>JSON</code> - A Json file.
     *         </p>
     *         </li>
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * An Amazon S3 pre-signed URL that points to the generated export file.
     * </p>
     * 
     * @return An Amazon S3 pre-signed URL that points to the generated export file.
     */
    public final String s3Url() {
        return s3Url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Url());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportDestination)) {
            return false;
        }
        ExportDestination other = (ExportDestination) obj;
        return Objects.equals(dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(s3Url(), other.s3Url());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportDestination").add("DataFormat", dataFormatAsString()).add("S3Url", s3Url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "S3Url":
            return Optional.ofNullable(clazz.cast(s3Url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportDestination, T> g) {
        return obj -> g.apply((ExportDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportDestination> {
        /**
         * <p>
         * The data format of the final export job file, can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CSV</code> - A comma-separated values file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JSON</code> - A Json file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataFormat
         *        The data format of the final export job file, can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CSV</code> - A comma-separated values file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JSON</code> - A Json file.
         *        </p>
         *        </li>
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The data format of the final export job file, can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CSV</code> - A comma-separated values file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>JSON</code> - A Json file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dataFormat
         *        The data format of the final export job file, can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CSV</code> - A comma-separated values file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>JSON</code> - A Json file.
         *        </p>
         *        </li>
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * An Amazon S3 pre-signed URL that points to the generated export file.
         * </p>
         * 
         * @param s3Url
         *        An Amazon S3 pre-signed URL that points to the generated export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Url(String s3Url);
    }

    static final class BuilderImpl implements Builder {
        private String dataFormat;

        private String s3Url;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportDestination model) {
            dataFormat(model.dataFormat);
            s3Url(model.s3Url);
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getS3Url() {
            return s3Url;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        @Override
        public ExportDestination build() {
            return new ExportDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
