/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadata;
import software.amazon.awssdk.services.sesv2.model.EmailTemplateMetadataListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEmailTemplatesResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListEmailTemplatesResponse> {
    private static final SdkField<List<EmailTemplateMetadata>> TEMPLATES_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplatesMetadata").getter(ListEmailTemplatesResponse.getter(ListEmailTemplatesResponse::templatesMetadata)).setter(ListEmailTemplatesResponse.setter(Builder::templatesMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatesMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EmailTemplateMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEmailTemplatesResponse.getter(ListEmailTemplatesResponse::nextToken)).setter(ListEmailTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_METADATA_FIELD, NEXT_TOKEN_FIELD));
    private final List<EmailTemplateMetadata> templatesMetadata;
    private final String nextToken;

    private ListEmailTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templatesMetadata = builder.templatesMetadata;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTemplatesMetadata() {
        return this.templatesMetadata != null && !(this.templatesMetadata instanceof SdkAutoConstructList);
    }

    public final List<EmailTemplateMetadata> templatesMetadata() {
        return this.templatesMetadata;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplatesMetadata() ? this.templatesMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEmailTemplatesResponse)) {
            return false;
        }
        ListEmailTemplatesResponse other = (ListEmailTemplatesResponse)((Object)obj);
        return this.hasTemplatesMetadata() == other.hasTemplatesMetadata() && Objects.equals(this.templatesMetadata(), other.templatesMetadata()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEmailTemplatesResponse").add("TemplatesMetadata", this.hasTemplatesMetadata() ? this.templatesMetadata() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplatesMetadata": {
                return Optional.ofNullable(clazz.cast(this.templatesMetadata()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEmailTemplatesResponse, T> g) {
        return obj -> g.apply((ListEmailTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<EmailTemplateMetadata> templatesMetadata = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEmailTemplatesResponse model) {
            super(model);
            this.templatesMetadata(model.templatesMetadata);
            this.nextToken(model.nextToken);
        }

        public final List<EmailTemplateMetadata.Builder> getTemplatesMetadata() {
            List<EmailTemplateMetadata.Builder> result = EmailTemplateMetadataListCopier.copyToBuilder(this.templatesMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplatesMetadata(Collection<EmailTemplateMetadata.BuilderImpl> templatesMetadata) {
            this.templatesMetadata = EmailTemplateMetadataListCopier.copyFromBuilder(templatesMetadata);
        }

        @Override
        public final Builder templatesMetadata(Collection<EmailTemplateMetadata> templatesMetadata) {
            this.templatesMetadata = EmailTemplateMetadataListCopier.copy(templatesMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(EmailTemplateMetadata ... templatesMetadata) {
            this.templatesMetadata(Arrays.asList(templatesMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesMetadata(Consumer<EmailTemplateMetadata.Builder> ... templatesMetadata) {
            this.templatesMetadata(Stream.of(templatesMetadata).map(c -> (EmailTemplateMetadata)((EmailTemplateMetadata.Builder)EmailTemplateMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEmailTemplatesResponse build() {
            return new ListEmailTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEmailTemplatesResponse> {
        public Builder templatesMetadata(Collection<EmailTemplateMetadata> var1);

        public Builder templatesMetadata(EmailTemplateMetadata ... var1);

        public Builder templatesMetadata(Consumer<EmailTemplateMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

