/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListExportJobsResponse;

public class ListExportJobsPublisher
implements SdkPublisher<ListExportJobsResponse> {
    private final SesV2AsyncClient client;
    private final ListExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExportJobsPublisher(SesV2AsyncClient client, ListExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExportJobsPublisher(SesV2AsyncClient client, ListExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExportJobsResponseFetcher
    implements AsyncPageFetcher<ListExportJobsResponse> {
        private ListExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExportJobsResponse> nextPage(ListExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListExportJobsPublisher.this.client.listExportJobs(ListExportJobsPublisher.this.firstRequest);
            }
            return ListExportJobsPublisher.this.client.listExportJobs((ListExportJobsRequest)((Object)ListExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

