/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.Contact;
import software.amazon.awssdk.services.sesv2.model.ListOfContactsCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactsResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, ListContactsResponse> {
    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contacts").getter(ListContactsResponse.getter(ListContactsResponse::contacts)).setter(ListContactsResponse.setter(Builder::contacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContactsResponse.getter(ListContactsResponse::nextToken)).setter(ListContactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<Contact> contacts;
    private final String nextToken;

    private ListContactsResponse(BuilderImpl builder) {
        super(builder);
        this.contacts = builder.contacts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasContacts() {
        return this.contacts != null && !(this.contacts instanceof SdkAutoConstructList);
    }

    public final List<Contact> contacts() {
        return this.contacts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContacts() ? this.contacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactsResponse)) {
            return false;
        }
        ListContactsResponse other = (ListContactsResponse)((Object)obj);
        return this.hasContacts() == other.hasContacts() && Objects.equals(this.contacts(), other.contacts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListContactsResponse").add("Contacts", this.hasContacts() ? this.contacts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Contacts": {
                return Optional.ofNullable(clazz.cast(this.contacts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactsResponse, T> g) {
        return obj -> g.apply((ListContactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactsResponse model) {
            super(model);
            this.contacts(model.contacts);
            this.nextToken(model.nextToken);
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = ListOfContactsCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = ListOfContactsCopier.copyFromBuilder(contacts);
        }

        @Override
        @Transient
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = ListOfContactsCopier.copy(contacts);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contacts(Contact ... contacts) {
            this.contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder> ... contacts) {
            this.contacts(Stream.of(contacts).map(c -> (Contact)((Contact.Builder)Contact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListContactsResponse build() {
            return new ListContactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactsResponse> {
        public Builder contacts(Collection<Contact> var1);

        public Builder contacts(Contact ... var1);

        public Builder contacts(Consumer<Contact.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

