/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.Tag;
import software.amazon.awssdk.services.sesv2.model.TagListCopier;
import software.amazon.awssdk.services.sesv2.model.Topic;
import software.amazon.awssdk.services.sesv2.model.TopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactListResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetContactListResponse> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactListName").getter(GetContactListResponse.getter(GetContactListResponse::contactListName)).setter(GetContactListResponse.setter(Builder::contactListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListName").build()}).build();
    private static final SdkField<List<Topic>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Topics").getter(GetContactListResponse.getter(GetContactListResponse::topics)).setter(GetContactListResponse.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Topic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetContactListResponse.getter(GetContactListResponse::description)).setter(GetContactListResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetContactListResponse.getter(GetContactListResponse::createdTimestamp)).setter(GetContactListResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(GetContactListResponse.getter(GetContactListResponse::lastUpdatedTimestamp)).setter(GetContactListResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetContactListResponse.getter(GetContactListResponse::tags)).setter(GetContactListResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD, TOPICS_FIELD, DESCRIPTION_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, TAGS_FIELD));
    private final String contactListName;
    private final List<Topic> topics;
    private final String description;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;
    private final List<Tag> tags;

    private GetContactListResponse(BuilderImpl builder) {
        super(builder);
        this.contactListName = builder.contactListName;
        this.topics = builder.topics;
        this.description = builder.description;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.tags = builder.tags;
    }

    public final String contactListName() {
        return this.contactListName;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<Topic> topics() {
        return this.topics;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactListResponse)) {
            return false;
        }
        GetContactListResponse other = (GetContactListResponse)((Object)obj);
        return Objects.equals(this.contactListName(), other.contactListName()) && this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetContactListResponse").add("ContactListName", (Object)this.contactListName()).add("Topics", this.hasTopics() ? this.topics() : null).add("Description", (Object)this.description()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactListName": {
                return Optional.ofNullable(clazz.cast(this.contactListName()));
            }
            case "Topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactListResponse, T> g) {
        return obj -> g.apply((GetContactListResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String contactListName;
        private List<Topic> topics = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactListResponse model) {
            super(model);
            this.contactListName(model.contactListName);
            this.topics(model.topics);
            this.description(model.description);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.tags(model.tags);
        }

        public final String getContactListName() {
            return this.contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        public final List<Topic.Builder> getTopics() {
            List<Topic.Builder> result = TopicsCopier.copyToBuilder(this.topics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<Topic.Builder> ... topics) {
            this.topics(Stream.of(topics).map(c -> (Topic)((Topic.Builder)Topic.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopics(Collection<Topic.BuilderImpl> topics) {
            this.topics = TopicsCopier.copyFromBuilder(topics);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public GetContactListResponse build() {
            return new GetContactListResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactListResponse> {
        public Builder contactListName(String var1);

        public Builder topics(Collection<Topic> var1);

        public Builder topics(Topic ... var1);

        public Builder topics(Consumer<Topic.Builder> ... var1);

        public Builder description(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

