/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsRequest;
import software.amazon.awssdk.services.sesv2.model.ListImportJobsResponse;

public class ListImportJobsPublisher
implements SdkPublisher<ListImportJobsResponse> {
    private final SesV2AsyncClient client;
    private final ListImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportJobsPublisher(SesV2AsyncClient client, ListImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportJobsPublisher(SesV2AsyncClient client, ListImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListImportJobsResponseFetcher
    implements AsyncPageFetcher<ListImportJobsResponse> {
        private ListImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportJobsResponse> nextPage(ListImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListImportJobsPublisher.this.client.listImportJobs(ListImportJobsPublisher.this.firstRequest);
            }
            return ListImportJobsPublisher.this.client.listImportJobs((ListImportJobsRequest)((Object)ListImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

