/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the entire content of the email, including the message headers and the body content. You can
 * create a simple email message, in which you specify the subject and the text and HTML versions of the message body.
 * You can also create raw messages, in which you specify a complete MIME-formatted message. Raw messages can include
 * attachments and custom headers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailContent implements SdkPojo, Serializable, ToCopyableBuilder<EmailContent.Builder, EmailContent> {
    private static final SdkField<Message> SIMPLE_FIELD = SdkField.<Message> builder(MarshallingType.SDK_POJO)
            .memberName("Simple").getter(getter(EmailContent::simple)).setter(setter(Builder::simple))
            .constructor(Message::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Simple").build()).build();

    private static final SdkField<RawMessage> RAW_FIELD = SdkField.<RawMessage> builder(MarshallingType.SDK_POJO)
            .memberName("Raw").getter(getter(EmailContent::raw)).setter(setter(Builder::raw)).constructor(RawMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Raw").build()).build();

    private static final SdkField<Template> TEMPLATE_FIELD = SdkField.<Template> builder(MarshallingType.SDK_POJO)
            .memberName("Template").getter(getter(EmailContent::template)).setter(setter(Builder::template))
            .constructor(Template::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_FIELD, RAW_FIELD,
            TEMPLATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Message simple;

    private final RawMessage raw;

    private final Template template;

    private EmailContent(BuilderImpl builder) {
        this.simple = builder.simple;
        this.raw = builder.raw;
        this.template = builder.template;
    }

    /**
     * <p>
     * The simple email message. The message consists of a subject and a message body.
     * </p>
     * 
     * @return The simple email message. The message consists of a subject and a message body.
     */
    public final Message simple() {
        return simple;
    }

    /**
     * <p>
     * The raw email message. The message has to meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The message has to contain a header and a body, separated by one blank line.
     * </p>
     * </li>
     * <li>
     * <p>
     * All of the required header fields must be present in the message.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each part of a multipart MIME message must be formatted properly.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you include attachments, they must be in a file format that the Amazon SES API v2 supports.
     * </p>
     * </li>
     * <li>
     * <p>
     * The entire message must be Base64 encoded.
     * </p>
     * </li>
     * <li>
     * <p>
     * If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range, you
     * should encode that content to ensure that recipients' email clients render the message properly.
     * </p>
     * </li>
     * <li>
     * <p>
     * The length of any single line of text in the message can't exceed 1,000 characters. This restriction is defined
     * in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The raw email message. The message has to meet the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The message has to contain a header and a body, separated by one blank line.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         All of the required header fields must be present in the message.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each part of a multipart MIME message must be formatted properly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you include attachments, they must be in a file format that the Amazon SES API v2 supports.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The entire message must be Base64 encoded.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character
     *         range, you should encode that content to ensure that recipients' email clients render the message
     *         properly.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The length of any single line of text in the message can't exceed 1,000 characters. This restriction is
     *         defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
     *         </p>
     *         </li>
     */
    public final RawMessage raw() {
        return raw;
    }

    /**
     * <p>
     * The template to use for the email message.
     * </p>
     * 
     * @return The template to use for the email message.
     */
    public final Template template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simple());
        hashCode = 31 * hashCode + Objects.hashCode(raw());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailContent)) {
            return false;
        }
        EmailContent other = (EmailContent) obj;
        return Objects.equals(simple(), other.simple()) && Objects.equals(raw(), other.raw())
                && Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmailContent").add("Simple", simple()).add("Raw", raw()).add("Template", template()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Simple":
            return Optional.ofNullable(clazz.cast(simple()));
        case "Raw":
            return Optional.ofNullable(clazz.cast(raw()));
        case "Template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailContent, T> g) {
        return obj -> g.apply((EmailContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailContent> {
        /**
         * <p>
         * The simple email message. The message consists of a subject and a message body.
         * </p>
         * 
         * @param simple
         *        The simple email message. The message consists of a subject and a message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simple(Message simple);

        /**
         * <p>
         * The simple email message. The message consists of a subject and a message body.
         * </p>
         * This is a convenience that creates an instance of the {@link Message.Builder} avoiding the need to create one
         * manually via {@link Message#builder()}.
         *
         * When the {@link Consumer} completes, {@link Message.Builder#build()} is called immediately and its result is
         * passed to {@link #simple(Message)}.
         * 
         * @param simple
         *        a consumer that will call methods on {@link Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simple(Message)
         */
        default Builder simple(Consumer<Message.Builder> simple) {
            return simple(Message.builder().applyMutation(simple).build());
        }

        /**
         * <p>
         * The raw email message. The message has to meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The message has to contain a header and a body, separated by one blank line.
         * </p>
         * </li>
         * <li>
         * <p>
         * All of the required header fields must be present in the message.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each part of a multipart MIME message must be formatted properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you include attachments, they must be in a file format that the Amazon SES API v2 supports.
         * </p>
         * </li>
         * <li>
         * <p>
         * The entire message must be Base64 encoded.
         * </p>
         * </li>
         * <li>
         * <p>
         * If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range,
         * you should encode that content to ensure that recipients' email clients render the message properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * The length of any single line of text in the message can't exceed 1,000 characters. This restriction is
         * defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param raw
         *        The raw email message. The message has to meet the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The message has to contain a header and a body, separated by one blank line.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        All of the required header fields must be present in the message.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Each part of a multipart MIME message must be formatted properly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you include attachments, they must be in a file format that the Amazon SES API v2 supports.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The entire message must be Base64 encoded.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character
         *        range, you should encode that content to ensure that recipients' email clients render the message
         *        properly.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The length of any single line of text in the message can't exceed 1,000 characters. This restriction
         *        is defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raw(RawMessage raw);

        /**
         * <p>
         * The raw email message. The message has to meet the following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The message has to contain a header and a body, separated by one blank line.
         * </p>
         * </li>
         * <li>
         * <p>
         * All of the required header fields must be present in the message.
         * </p>
         * </li>
         * <li>
         * <p>
         * Each part of a multipart MIME message must be formatted properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you include attachments, they must be in a file format that the Amazon SES API v2 supports.
         * </p>
         * </li>
         * <li>
         * <p>
         * The entire message must be Base64 encoded.
         * </p>
         * </li>
         * <li>
         * <p>
         * If any of the MIME parts in your message contain content that is outside of the 7-bit ASCII character range,
         * you should encode that content to ensure that recipients' email clients render the message properly.
         * </p>
         * </li>
         * <li>
         * <p>
         * The length of any single line of text in the message can't exceed 1,000 characters. This restriction is
         * defined in <a href="https://tools.ietf.org/html/rfc5321">RFC 5321</a>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link RawMessage.Builder} avoiding the need to create
         * one manually via {@link RawMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link RawMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #raw(RawMessage)}.
         * 
         * @param raw
         *        a consumer that will call methods on {@link RawMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #raw(RawMessage)
         */
        default Builder raw(Consumer<RawMessage.Builder> raw) {
            return raw(RawMessage.builder().applyMutation(raw).build());
        }

        /**
         * <p>
         * The template to use for the email message.
         * </p>
         * 
         * @param template
         *        The template to use for the email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Template template);

        /**
         * <p>
         * The template to use for the email message.
         * </p>
         * This is a convenience that creates an instance of the {@link Template.Builder} avoiding the need to create
         * one manually via {@link Template#builder()}.
         *
         * When the {@link Consumer} completes, {@link Template.Builder#build()} is called immediately and its result is
         * passed to {@link #template(Template)}.
         * 
         * @param template
         *        a consumer that will call methods on {@link Template.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #template(Template)
         */
        default Builder template(Consumer<Template.Builder> template) {
            return template(Template.builder().applyMutation(template).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Message simple;

        private RawMessage raw;

        private Template template;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailContent model) {
            simple(model.simple);
            raw(model.raw);
            template(model.template);
        }

        public final Message.Builder getSimple() {
            return simple != null ? simple.toBuilder() : null;
        }

        @Override
        public final Builder simple(Message simple) {
            this.simple = simple;
            return this;
        }

        public final void setSimple(Message.BuilderImpl simple) {
            this.simple = simple != null ? simple.build() : null;
        }

        public final RawMessage.Builder getRaw() {
            return raw != null ? raw.toBuilder() : null;
        }

        @Override
        public final Builder raw(RawMessage raw) {
            this.raw = raw;
            return this;
        }

        public final void setRaw(RawMessage.BuilderImpl raw) {
            this.raw = raw != null ? raw.build() : null;
        }

        public final Template.Builder getTemplate() {
            return template != null ? template.toBuilder() : null;
        }

        @Override
        public final Builder template(Template template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(Template.BuilderImpl template) {
            this.template = template != null ? template.build() : null;
        }

        @Override
        public EmailContent build() {
            return new EmailContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
