/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the action of a contact list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactListDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactListDestination.Builder, ContactListDestination> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactListName").getter(getter(ContactListDestination::contactListName))
            .setter(setter(Builder::contactListName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListName").build()).build();

    private static final SdkField<String> CONTACT_LIST_IMPORT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactListImportAction").getter(getter(ContactListDestination::contactListImportActionAsString))
            .setter(setter(Builder::contactListImportAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListImportAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD,
            CONTACT_LIST_IMPORT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactListName;

    private final String contactListImportAction;

    private ContactListDestination(BuilderImpl builder) {
        this.contactListName = builder.contactListName;
        this.contactListImportAction = builder.contactListImportAction;
    }

    /**
     * <p>
     * The name of the contact list.
     * </p>
     * 
     * @return The name of the contact list.
     */
    public final String contactListName() {
        return contactListName;
    }

    /**
     * <p>
     * &gt;The type of action that you want to perform on the addresses. Acceptable values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT: add the addresses to the contact list. If the record already exists, it will override it with the new value.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE: remove the addresses from the contact list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contactListImportAction} will return {@link ContactListImportAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contactListImportActionAsString}.
     * </p>
     * 
     * @return &gt;The type of action that you want to perform on the addresses. Acceptable values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT: add the addresses to the contact list. If the record already exists, it will override it with the
     *         new value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE: remove the addresses from the contact list.
     *         </p>
     *         </li>
     * @see ContactListImportAction
     */
    public final ContactListImportAction contactListImportAction() {
        return ContactListImportAction.fromValue(contactListImportAction);
    }

    /**
     * <p>
     * &gt;The type of action that you want to perform on the addresses. Acceptable values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT: add the addresses to the contact list. If the record already exists, it will override it with the new value.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE: remove the addresses from the contact list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contactListImportAction} will return {@link ContactListImportAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contactListImportActionAsString}.
     * </p>
     * 
     * @return &gt;The type of action that you want to perform on the addresses. Acceptable values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT: add the addresses to the contact list. If the record already exists, it will override it with the
     *         new value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE: remove the addresses from the contact list.
     *         </p>
     *         </li>
     * @see ContactListImportAction
     */
    public final String contactListImportActionAsString() {
        return contactListImportAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(contactListImportActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactListDestination)) {
            return false;
        }
        ContactListDestination other = (ContactListDestination) obj;
        return Objects.equals(contactListName(), other.contactListName())
                && Objects.equals(contactListImportActionAsString(), other.contactListImportActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactListDestination").add("ContactListName", contactListName())
                .add("ContactListImportAction", contactListImportActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactListName":
            return Optional.ofNullable(clazz.cast(contactListName()));
        case "ContactListImportAction":
            return Optional.ofNullable(clazz.cast(contactListImportActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactListDestination, T> g) {
        return obj -> g.apply((ContactListDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactListDestination> {
        /**
         * <p>
         * The name of the contact list.
         * </p>
         * 
         * @param contactListName
         *        The name of the contact list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactListName(String contactListName);

        /**
         * <p>
         * &gt;The type of action that you want to perform on the addresses. Acceptable values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT: add the addresses to the contact list. If the record already exists, it will override it with the new
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE: remove the addresses from the contact list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contactListImportAction
         *        &gt;The type of action that you want to perform on the addresses. Acceptable values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT: add the addresses to the contact list. If the record already exists, it will override it with the
         *        new value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE: remove the addresses from the contact list.
         *        </p>
         *        </li>
         * @see ContactListImportAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactListImportAction
         */
        Builder contactListImportAction(String contactListImportAction);

        /**
         * <p>
         * &gt;The type of action that you want to perform on the addresses. Acceptable values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT: add the addresses to the contact list. If the record already exists, it will override it with the new
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE: remove the addresses from the contact list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contactListImportAction
         *        &gt;The type of action that you want to perform on the addresses. Acceptable values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT: add the addresses to the contact list. If the record already exists, it will override it with the
         *        new value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE: remove the addresses from the contact list.
         *        </p>
         *        </li>
         * @see ContactListImportAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactListImportAction
         */
        Builder contactListImportAction(ContactListImportAction contactListImportAction);
    }

    static final class BuilderImpl implements Builder {
        private String contactListName;

        private String contactListImportAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactListDestination model) {
            contactListName(model.contactListName);
            contactListImportAction(model.contactListImportAction);
        }

        public final String getContactListName() {
            return contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        public final String getContactListImportAction() {
            return contactListImportAction;
        }

        @Override
        public final Builder contactListImportAction(String contactListImportAction) {
            this.contactListImportAction = contactListImportAction;
            return this;
        }

        @Override
        public final Builder contactListImportAction(ContactListImportAction contactListImportAction) {
            this.contactListImportAction(contactListImportAction == null ? null : contactListImportAction.toString());
            return this;
        }

        public final void setContactListImportAction(String contactListImportAction) {
            this.contactListImportAction = contactListImportAction;
        }

        @Override
        public ContactListDestination build() {
            return new ContactListDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
