/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DkimSigningAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DkimSigningAttributes> {
    private static final SdkField<String> DOMAIN_SIGNING_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainSigningSelector").getter(DkimSigningAttributes.getter(DkimSigningAttributes::domainSigningSelector)).setter(DkimSigningAttributes.setter(Builder::domainSigningSelector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSigningSelector").build()}).build();
    private static final SdkField<String> DOMAIN_SIGNING_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainSigningPrivateKey").getter(DkimSigningAttributes.getter(DkimSigningAttributes::domainSigningPrivateKey)).setter(DkimSigningAttributes.setter(Builder::domainSigningPrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSigningPrivateKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_SIGNING_SELECTOR_FIELD, DOMAIN_SIGNING_PRIVATE_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainSigningSelector;
    private final String domainSigningPrivateKey;

    private DkimSigningAttributes(BuilderImpl builder) {
        this.domainSigningSelector = builder.domainSigningSelector;
        this.domainSigningPrivateKey = builder.domainSigningPrivateKey;
    }

    public final String domainSigningSelector() {
        return this.domainSigningSelector;
    }

    public final String domainSigningPrivateKey() {
        return this.domainSigningPrivateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainSigningSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainSigningPrivateKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimSigningAttributes)) {
            return false;
        }
        DkimSigningAttributes other = (DkimSigningAttributes)obj;
        return Objects.equals(this.domainSigningSelector(), other.domainSigningSelector()) && Objects.equals(this.domainSigningPrivateKey(), other.domainSigningPrivateKey());
    }

    public final String toString() {
        return ToString.builder((String)"DkimSigningAttributes").add("DomainSigningSelector", (Object)this.domainSigningSelector()).add("DomainSigningPrivateKey", (Object)(this.domainSigningPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainSigningSelector": {
                return Optional.ofNullable(clazz.cast(this.domainSigningSelector()));
            }
            case "DomainSigningPrivateKey": {
                return Optional.ofNullable(clazz.cast(this.domainSigningPrivateKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DkimSigningAttributes, T> g) {
        return obj -> g.apply((DkimSigningAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainSigningSelector;
        private String domainSigningPrivateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DkimSigningAttributes model) {
            this.domainSigningSelector(model.domainSigningSelector);
            this.domainSigningPrivateKey(model.domainSigningPrivateKey);
        }

        public final String getDomainSigningSelector() {
            return this.domainSigningSelector;
        }

        @Override
        public final Builder domainSigningSelector(String domainSigningSelector) {
            this.domainSigningSelector = domainSigningSelector;
            return this;
        }

        public final void setDomainSigningSelector(String domainSigningSelector) {
            this.domainSigningSelector = domainSigningSelector;
        }

        public final String getDomainSigningPrivateKey() {
            return this.domainSigningPrivateKey;
        }

        @Override
        public final Builder domainSigningPrivateKey(String domainSigningPrivateKey) {
            this.domainSigningPrivateKey = domainSigningPrivateKey;
            return this;
        }

        public final void setDomainSigningPrivateKey(String domainSigningPrivateKey) {
            this.domainSigningPrivateKey = domainSigningPrivateKey;
        }

        public DkimSigningAttributes build() {
            return new DkimSigningAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DkimSigningAttributes> {
        public Builder domainSigningSelector(String var1);

        public Builder domainSigningPrivateKey(String var1);
    }
}

