/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.BehaviorOnMxFailure;
import software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MailFromAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MailFromAttributes> {
    private static final SdkField<String> MAIL_FROM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailFromDomain").getter(MailFromAttributes.getter(MailFromAttributes::mailFromDomain)).setter(MailFromAttributes.setter(Builder::mailFromDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomain").build()}).build();
    private static final SdkField<String> MAIL_FROM_DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailFromDomainStatus").getter(MailFromAttributes.getter(MailFromAttributes::mailFromDomainStatusAsString)).setter(MailFromAttributes.setter(Builder::mailFromDomainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomainStatus").build()}).build();
    private static final SdkField<String> BEHAVIOR_ON_MX_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BehaviorOnMxFailure").getter(MailFromAttributes.getter(MailFromAttributes::behaviorOnMxFailureAsString)).setter(MailFromAttributes.setter(Builder::behaviorOnMxFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorOnMxFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_FROM_DOMAIN_FIELD, MAIL_FROM_DOMAIN_STATUS_FIELD, BEHAVIOR_ON_MX_FAILURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mailFromDomain;
    private final String mailFromDomainStatus;
    private final String behaviorOnMxFailure;

    private MailFromAttributes(BuilderImpl builder) {
        this.mailFromDomain = builder.mailFromDomain;
        this.mailFromDomainStatus = builder.mailFromDomainStatus;
        this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
    }

    public String mailFromDomain() {
        return this.mailFromDomain;
    }

    public MailFromDomainStatus mailFromDomainStatus() {
        return MailFromDomainStatus.fromValue(this.mailFromDomainStatus);
    }

    public String mailFromDomainStatusAsString() {
        return this.mailFromDomainStatus;
    }

    public BehaviorOnMxFailure behaviorOnMxFailure() {
        return BehaviorOnMxFailure.fromValue(this.behaviorOnMxFailure);
    }

    public String behaviorOnMxFailureAsString() {
        return this.behaviorOnMxFailure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorOnMxFailureAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MailFromAttributes)) {
            return false;
        }
        MailFromAttributes other = (MailFromAttributes)obj;
        return Objects.equals(this.mailFromDomain(), other.mailFromDomain()) && Objects.equals(this.mailFromDomainStatusAsString(), other.mailFromDomainStatusAsString()) && Objects.equals(this.behaviorOnMxFailureAsString(), other.behaviorOnMxFailureAsString());
    }

    public String toString() {
        return ToString.builder((String)"MailFromAttributes").add("MailFromDomain", (Object)this.mailFromDomain()).add("MailFromDomainStatus", (Object)this.mailFromDomainStatusAsString()).add("BehaviorOnMxFailure", (Object)this.behaviorOnMxFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MailFromDomain": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomain()));
            }
            case "MailFromDomainStatus": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomainStatusAsString()));
            }
            case "BehaviorOnMxFailure": {
                return Optional.ofNullable(clazz.cast(this.behaviorOnMxFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MailFromAttributes, T> g) {
        return obj -> g.apply((MailFromAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mailFromDomain;
        private String mailFromDomainStatus;
        private String behaviorOnMxFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(MailFromAttributes model) {
            this.mailFromDomain(model.mailFromDomain);
            this.mailFromDomainStatus(model.mailFromDomainStatus);
            this.behaviorOnMxFailure(model.behaviorOnMxFailure);
        }

        public final String getMailFromDomain() {
            return this.mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getMailFromDomainStatus() {
            return this.mailFromDomainStatus;
        }

        @Override
        public final Builder mailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
            return this;
        }

        @Override
        public final Builder mailFromDomainStatus(MailFromDomainStatus mailFromDomainStatus) {
            this.mailFromDomainStatus(mailFromDomainStatus == null ? null : mailFromDomainStatus.toString());
            return this;
        }

        public final void setMailFromDomainStatus(String mailFromDomainStatus) {
            this.mailFromDomainStatus = mailFromDomainStatus;
        }

        public final String getBehaviorOnMxFailure() {
            return this.behaviorOnMxFailure;
        }

        @Override
        public final Builder behaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMxFailure(BehaviorOnMxFailure behaviorOnMxFailure) {
            this.behaviorOnMxFailure(behaviorOnMxFailure == null ? null : behaviorOnMxFailure.toString());
            return this;
        }

        public final void setBehaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
        }

        public MailFromAttributes build() {
            return new MailFromAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MailFromAttributes> {
        public Builder mailFromDomain(String var1);

        public Builder mailFromDomainStatus(String var1);

        public Builder mailFromDomainStatus(MailFromDomainStatus var1);

        public Builder behaviorOnMxFailure(String var1);

        public Builder behaviorOnMxFailure(BehaviorOnMxFailure var1);
    }
}

