/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin;
import software.amazon.awssdk.services.sesv2.model.DkimStatus;
import software.amazon.awssdk.services.sesv2.model.DnsTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DkimAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DkimAttributes> {
    private static final SdkField<Boolean> SIGNING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SigningEnabled").getter(DkimAttributes.getter(DkimAttributes::signingEnabled)).setter(DkimAttributes.setter(Builder::signingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningEnabled").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DkimAttributes.getter(DkimAttributes::statusAsString)).setter(DkimAttributes.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tokens").getter(DkimAttributes.getter(DkimAttributes::tokens)).setter(DkimAttributes.setter(Builder::tokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SIGNING_ATTRIBUTES_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SigningAttributesOrigin").getter(DkimAttributes.getter(DkimAttributes::signingAttributesOriginAsString)).setter(DkimAttributes.setter(Builder::signingAttributesOrigin)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAttributesOrigin").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_ENABLED_FIELD, STATUS_FIELD, TOKENS_FIELD, SIGNING_ATTRIBUTES_ORIGIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean signingEnabled;
    private final String status;
    private final List<String> tokens;
    private final String signingAttributesOrigin;

    private DkimAttributes(BuilderImpl builder) {
        this.signingEnabled = builder.signingEnabled;
        this.status = builder.status;
        this.tokens = builder.tokens;
        this.signingAttributesOrigin = builder.signingAttributesOrigin;
    }

    public Boolean signingEnabled() {
        return this.signingEnabled;
    }

    public DkimStatus status() {
        return DkimStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasTokens() {
        return this.tokens != null && !(this.tokens instanceof SdkAutoConstructList);
    }

    public List<String> tokens() {
        return this.tokens;
    }

    public DkimSigningAttributesOrigin signingAttributesOrigin() {
        return DkimSigningAttributesOrigin.fromValue(this.signingAttributesOrigin);
    }

    public String signingAttributesOriginAsString() {
        return this.signingAttributesOrigin;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAttributesOriginAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DkimAttributes)) {
            return false;
        }
        DkimAttributes other = (DkimAttributes)obj;
        return Objects.equals(this.signingEnabled(), other.signingEnabled()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.tokens(), other.tokens()) && Objects.equals(this.signingAttributesOriginAsString(), other.signingAttributesOriginAsString());
    }

    public String toString() {
        return ToString.builder((String)"DkimAttributes").add("SigningEnabled", (Object)this.signingEnabled()).add("Status", (Object)this.statusAsString()).add("Tokens", this.tokens()).add("SigningAttributesOrigin", (Object)this.signingAttributesOriginAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SigningEnabled": {
                return Optional.ofNullable(clazz.cast(this.signingEnabled()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tokens": {
                return Optional.ofNullable(clazz.cast(this.tokens()));
            }
            case "SigningAttributesOrigin": {
                return Optional.ofNullable(clazz.cast(this.signingAttributesOriginAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DkimAttributes, T> g) {
        return obj -> g.apply((DkimAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean signingEnabled;
        private String status;
        private List<String> tokens = DefaultSdkAutoConstructList.getInstance();
        private String signingAttributesOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(DkimAttributes model) {
            this.signingEnabled(model.signingEnabled);
            this.status(model.status);
            this.tokens(model.tokens);
            this.signingAttributesOrigin(model.signingAttributesOrigin);
        }

        public final Boolean getSigningEnabled() {
            return this.signingEnabled;
        }

        @Override
        public final Builder signingEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
            return this;
        }

        public final void setSigningEnabled(Boolean signingEnabled) {
            this.signingEnabled = signingEnabled;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DkimStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getTokens() {
            return this.tokens;
        }

        @Override
        public final Builder tokens(Collection<String> tokens) {
            this.tokens = DnsTokenListCopier.copy(tokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokens(String ... tokens) {
            this.tokens(Arrays.asList(tokens));
            return this;
        }

        public final void setTokens(Collection<String> tokens) {
            this.tokens = DnsTokenListCopier.copy(tokens);
        }

        public final String getSigningAttributesOrigin() {
            return this.signingAttributesOrigin;
        }

        @Override
        public final Builder signingAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
            return this;
        }

        @Override
        public final Builder signingAttributesOrigin(DkimSigningAttributesOrigin signingAttributesOrigin) {
            this.signingAttributesOrigin(signingAttributesOrigin == null ? null : signingAttributesOrigin.toString());
            return this;
        }

        public final void setSigningAttributesOrigin(String signingAttributesOrigin) {
            this.signingAttributesOrigin = signingAttributesOrigin;
        }

        public DkimAttributes build() {
            return new DkimAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DkimAttributes> {
        public Builder signingEnabled(Boolean var1);

        public Builder status(String var1);

        public Builder status(DkimStatus var1);

        public Builder tokens(Collection<String> var1);

        public Builder tokens(String ... var1);

        public Builder signingAttributesOrigin(String var1);

        public Builder signingAttributesOrigin(DkimSigningAttributesOrigin var1);
    }
}

