/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResult;
import software.amazon.awssdk.services.sesv2.model.BulkEmailEntryResultListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendBulkEmailResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, SendBulkEmailResponse> {
    private static final SdkField<List<BulkEmailEntryResult>> BULK_EMAIL_ENTRY_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendBulkEmailResponse.getter(SendBulkEmailResponse::bulkEmailEntryResults)).setter(SendBulkEmailResponse.setter(Builder::bulkEmailEntryResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BulkEmailEntryResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BulkEmailEntryResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BULK_EMAIL_ENTRY_RESULTS_FIELD));
    private final List<BulkEmailEntryResult> bulkEmailEntryResults;

    private SendBulkEmailResponse(BuilderImpl builder) {
        super(builder);
        this.bulkEmailEntryResults = builder.bulkEmailEntryResults;
    }

    public boolean hasBulkEmailEntryResults() {
        return this.bulkEmailEntryResults != null && !(this.bulkEmailEntryResults instanceof SdkAutoConstructList);
    }

    public List<BulkEmailEntryResult> bulkEmailEntryResults() {
        return this.bulkEmailEntryResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.bulkEmailEntryResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkEmailResponse)) {
            return false;
        }
        SendBulkEmailResponse other = (SendBulkEmailResponse)((Object)obj);
        return Objects.equals(this.bulkEmailEntryResults(), other.bulkEmailEntryResults());
    }

    public String toString() {
        return ToString.builder((String)"SendBulkEmailResponse").add("BulkEmailEntryResults", this.bulkEmailEntryResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BulkEmailEntryResults": {
                return Optional.ofNullable(clazz.cast(this.bulkEmailEntryResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBulkEmailResponse, T> g) {
        return obj -> g.apply((SendBulkEmailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private List<BulkEmailEntryResult> bulkEmailEntryResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkEmailResponse model) {
            super(model);
            this.bulkEmailEntryResults(model.bulkEmailEntryResults);
        }

        public final Collection<BulkEmailEntryResult.Builder> getBulkEmailEntryResults() {
            return this.bulkEmailEntryResults != null ? (Collection)this.bulkEmailEntryResults.stream().map(BulkEmailEntryResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bulkEmailEntryResults(Collection<BulkEmailEntryResult> bulkEmailEntryResults) {
            this.bulkEmailEntryResults = BulkEmailEntryResultListCopier.copy(bulkEmailEntryResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkEmailEntryResults(BulkEmailEntryResult ... bulkEmailEntryResults) {
            this.bulkEmailEntryResults(Arrays.asList(bulkEmailEntryResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bulkEmailEntryResults(Consumer<BulkEmailEntryResult.Builder> ... bulkEmailEntryResults) {
            this.bulkEmailEntryResults(Stream.of(bulkEmailEntryResults).map(c -> (BulkEmailEntryResult)((BulkEmailEntryResult.Builder)BulkEmailEntryResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBulkEmailEntryResults(Collection<BulkEmailEntryResult.BuilderImpl> bulkEmailEntryResults) {
            this.bulkEmailEntryResults = BulkEmailEntryResultListCopier.copyFromBuilder(bulkEmailEntryResults);
        }

        @Override
        public SendBulkEmailResponse build() {
            return new SendBulkEmailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendBulkEmailResponse> {
        public Builder bulkEmailEntryResults(Collection<BulkEmailEntryResult> var1);

        public Builder bulkEmailEntryResults(BulkEmailEntryResult ... var1);

        public Builder bulkEmailEntryResults(Consumer<BulkEmailEntryResult.Builder> ... var1);
    }
}

