/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SuppressionListReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuppressedDestinationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuppressedDestinationSummary> {
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SuppressedDestinationSummary.getter(SuppressedDestinationSummary::emailAddress)).setter(SuppressedDestinationSummary.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SuppressedDestinationSummary.getter(SuppressedDestinationSummary::reasonAsString)).setter(SuppressedDestinationSummary.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SuppressedDestinationSummary.getter(SuppressedDestinationSummary::lastUpdateTime)).setter(SuppressedDestinationSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_ADDRESS_FIELD, REASON_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String emailAddress;
    private final String reason;
    private final Instant lastUpdateTime;

    private SuppressedDestinationSummary(BuilderImpl builder) {
        this.emailAddress = builder.emailAddress;
        this.reason = builder.reason;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public String emailAddress() {
        return this.emailAddress;
    }

    public SuppressionListReason reason() {
        return SuppressionListReason.fromValue(this.reason);
    }

    public String reasonAsString() {
        return this.reason;
    }

    public Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressedDestinationSummary)) {
            return false;
        }
        SuppressedDestinationSummary other = (SuppressedDestinationSummary)obj;
        return Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public String toString() {
        return ToString.builder((String)"SuppressedDestinationSummary").add("EmailAddress", (Object)this.emailAddress()).add("Reason", (Object)this.reasonAsString()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuppressedDestinationSummary, T> g) {
        return obj -> g.apply((SuppressedDestinationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String emailAddress;
        private String reason;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressedDestinationSummary model) {
            this.emailAddress(model.emailAddress);
            this.reason(model.reason);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getReasonAsString() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(SuppressionListReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public SuppressedDestinationSummary build() {
            return new SuppressedDestinationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuppressedDestinationSummary> {
        public Builder emailAddress(String var1);

        public Builder reason(String var1);

        public Builder reason(SuppressionListReason var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

