/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BounceType {
    DOES_NOT_EXIST("DoesNotExist"),
    MESSAGE_TOO_LARGE("MessageTooLarge"),
    EXCEEDED_QUOTA("ExceededQuota"),
    CONTENT_REJECTED("ContentRejected"),
    UNDEFINED("Undefined"),
    TEMPORARY_FAILURE("TemporaryFailure"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BounceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BounceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BounceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BounceType> knownValues() {
        return Stream.of(BounceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

