/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.NotificationType;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetIdentityNotificationTopicRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SetIdentityNotificationTopicRequest> {
    private static final SdkField<String> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetIdentityNotificationTopicRequest.getter(SetIdentityNotificationTopicRequest::identity)).setter(SetIdentityNotificationTopicRequest.setter(Builder::identity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()}).build();
    private static final SdkField<String> NOTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetIdentityNotificationTopicRequest.getter(SetIdentityNotificationTopicRequest::notificationTypeAsString)).setter(SetIdentityNotificationTopicRequest.setter(Builder::notificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationType").build()}).build();
    private static final SdkField<String> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetIdentityNotificationTopicRequest.getter(SetIdentityNotificationTopicRequest::snsTopic)).setter(SetIdentityNotificationTopicRequest.setter(Builder::snsTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD, NOTIFICATION_TYPE_FIELD, SNS_TOPIC_FIELD));
    private final String identity;
    private final String notificationType;
    private final String snsTopic;

    private SetIdentityNotificationTopicRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.notificationType = builder.notificationType;
        this.snsTopic = builder.snsTopic;
    }

    public String identity() {
        return this.identity;
    }

    public NotificationType notificationType() {
        return NotificationType.fromValue(this.notificationType);
    }

    public String notificationTypeAsString() {
        return this.notificationType;
    }

    public String snsTopic() {
        return this.snsTopic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityNotificationTopicRequest)) {
            return false;
        }
        SetIdentityNotificationTopicRequest other = (SetIdentityNotificationTopicRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.notificationTypeAsString(), other.notificationTypeAsString()) && Objects.equals(this.snsTopic(), other.snsTopic());
    }

    public String toString() {
        return ToString.builder((String)"SetIdentityNotificationTopicRequest").add("Identity", (Object)this.identity()).add("NotificationType", (Object)this.notificationTypeAsString()).add("SnsTopic", (Object)this.snsTopic()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "NotificationType": {
                return Optional.ofNullable(clazz.cast(this.notificationTypeAsString()));
            }
            case "SnsTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetIdentityNotificationTopicRequest, T> g) {
        return obj -> g.apply((SetIdentityNotificationTopicRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String identity;
        private String notificationType;
        private String snsTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityNotificationTopicRequest model) {
            super(model);
            this.identity(model.identity);
            this.notificationType(model.notificationType);
            this.snsTopic(model.snsTopic);
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final String getNotificationTypeAsString() {
            return this.notificationType;
        }

        @Override
        public final Builder notificationType(String notificationType) {
            this.notificationType = notificationType;
            return this;
        }

        @Override
        public final Builder notificationType(NotificationType notificationType) {
            this.notificationType(notificationType.toString());
            return this;
        }

        public final void setNotificationType(String notificationType) {
            this.notificationType = notificationType;
        }

        public final String getSnsTopic() {
            return this.snsTopic;
        }

        @Override
        public final Builder snsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
            return this;
        }

        public final void setSnsTopic(String snsTopic) {
            this.snsTopic = snsTopic;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityNotificationTopicRequest build() {
            return new SetIdentityNotificationTopicRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetIdentityNotificationTopicRequest> {
        public Builder identity(String var1);

        public Builder notificationType(String var1);

        public Builder notificationType(NotificationType var1);

        public Builder snsTopic(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

