/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfo;
import software.amazon.awssdk.services.ses.model.BouncedRecipientInfoListCopier;
import software.amazon.awssdk.services.ses.model.MessageDsn;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendBounceRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SendBounceRequest> {
    private static final SdkField<String> ORIGINAL_MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendBounceRequest.getter(SendBounceRequest::originalMessageId)).setter(SendBounceRequest.setter(Builder::originalMessageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalMessageId").build()}).build();
    private static final SdkField<String> BOUNCE_SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendBounceRequest.getter(SendBounceRequest::bounceSender)).setter(SendBounceRequest.setter(Builder::bounceSender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceSender").build()}).build();
    private static final SdkField<String> EXPLANATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendBounceRequest.getter(SendBounceRequest::explanation)).setter(SendBounceRequest.setter(Builder::explanation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explanation").build()}).build();
    private static final SdkField<MessageDsn> MESSAGE_DSN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SendBounceRequest.getter(SendBounceRequest::messageDsn)).setter(SendBounceRequest.setter(Builder::messageDsn)).constructor(MessageDsn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageDsn").build()}).build();
    private static final SdkField<List<BouncedRecipientInfo>> BOUNCED_RECIPIENT_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SendBounceRequest.getter(SendBounceRequest::bouncedRecipientInfoList)).setter(SendBounceRequest.setter(Builder::bouncedRecipientInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BouncedRecipientInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BouncedRecipientInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BOUNCE_SENDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SendBounceRequest.getter(SendBounceRequest::bounceSenderArn)).setter(SendBounceRequest.setter(Builder::bounceSenderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceSenderArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_MESSAGE_ID_FIELD, BOUNCE_SENDER_FIELD, EXPLANATION_FIELD, MESSAGE_DSN_FIELD, BOUNCED_RECIPIENT_INFO_LIST_FIELD, BOUNCE_SENDER_ARN_FIELD));
    private final String originalMessageId;
    private final String bounceSender;
    private final String explanation;
    private final MessageDsn messageDsn;
    private final List<BouncedRecipientInfo> bouncedRecipientInfoList;
    private final String bounceSenderArn;

    private SendBounceRequest(BuilderImpl builder) {
        super(builder);
        this.originalMessageId = builder.originalMessageId;
        this.bounceSender = builder.bounceSender;
        this.explanation = builder.explanation;
        this.messageDsn = builder.messageDsn;
        this.bouncedRecipientInfoList = builder.bouncedRecipientInfoList;
        this.bounceSenderArn = builder.bounceSenderArn;
    }

    public String originalMessageId() {
        return this.originalMessageId;
    }

    public String bounceSender() {
        return this.bounceSender;
    }

    public String explanation() {
        return this.explanation;
    }

    public MessageDsn messageDsn() {
        return this.messageDsn;
    }

    public List<BouncedRecipientInfo> bouncedRecipientInfoList() {
        return this.bouncedRecipientInfoList;
    }

    public String bounceSenderArn() {
        return this.bounceSenderArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originalMessageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceSender());
        hashCode = 31 * hashCode + Objects.hashCode(this.explanation());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageDsn());
        hashCode = 31 * hashCode + Objects.hashCode(this.bouncedRecipientInfoList());
        hashCode = 31 * hashCode + Objects.hashCode(this.bounceSenderArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBounceRequest)) {
            return false;
        }
        SendBounceRequest other = (SendBounceRequest)((Object)obj);
        return Objects.equals(this.originalMessageId(), other.originalMessageId()) && Objects.equals(this.bounceSender(), other.bounceSender()) && Objects.equals(this.explanation(), other.explanation()) && Objects.equals(this.messageDsn(), other.messageDsn()) && Objects.equals(this.bouncedRecipientInfoList(), other.bouncedRecipientInfoList()) && Objects.equals(this.bounceSenderArn(), other.bounceSenderArn());
    }

    public String toString() {
        return ToString.builder((String)"SendBounceRequest").add("OriginalMessageId", (Object)this.originalMessageId()).add("BounceSender", (Object)this.bounceSender()).add("Explanation", (Object)this.explanation()).add("MessageDsn", (Object)this.messageDsn()).add("BouncedRecipientInfoList", this.bouncedRecipientInfoList()).add("BounceSenderArn", (Object)this.bounceSenderArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginalMessageId": {
                return Optional.ofNullable(clazz.cast(this.originalMessageId()));
            }
            case "BounceSender": {
                return Optional.ofNullable(clazz.cast(this.bounceSender()));
            }
            case "Explanation": {
                return Optional.ofNullable(clazz.cast(this.explanation()));
            }
            case "MessageDsn": {
                return Optional.ofNullable(clazz.cast(this.messageDsn()));
            }
            case "BouncedRecipientInfoList": {
                return Optional.ofNullable(clazz.cast(this.bouncedRecipientInfoList()));
            }
            case "BounceSenderArn": {
                return Optional.ofNullable(clazz.cast(this.bounceSenderArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBounceRequest, T> g) {
        return obj -> g.apply((SendBounceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String originalMessageId;
        private String bounceSender;
        private String explanation;
        private MessageDsn messageDsn;
        private List<BouncedRecipientInfo> bouncedRecipientInfoList = DefaultSdkAutoConstructList.getInstance();
        private String bounceSenderArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SendBounceRequest model) {
            super(model);
            this.originalMessageId(model.originalMessageId);
            this.bounceSender(model.bounceSender);
            this.explanation(model.explanation);
            this.messageDsn(model.messageDsn);
            this.bouncedRecipientInfoList(model.bouncedRecipientInfoList);
            this.bounceSenderArn(model.bounceSenderArn);
        }

        public final String getOriginalMessageId() {
            return this.originalMessageId;
        }

        @Override
        public final Builder originalMessageId(String originalMessageId) {
            this.originalMessageId = originalMessageId;
            return this;
        }

        public final void setOriginalMessageId(String originalMessageId) {
            this.originalMessageId = originalMessageId;
        }

        public final String getBounceSender() {
            return this.bounceSender;
        }

        @Override
        public final Builder bounceSender(String bounceSender) {
            this.bounceSender = bounceSender;
            return this;
        }

        public final void setBounceSender(String bounceSender) {
            this.bounceSender = bounceSender;
        }

        public final String getExplanation() {
            return this.explanation;
        }

        @Override
        public final Builder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        public final void setExplanation(String explanation) {
            this.explanation = explanation;
        }

        public final MessageDsn.Builder getMessageDsn() {
            return this.messageDsn != null ? this.messageDsn.toBuilder() : null;
        }

        @Override
        public final Builder messageDsn(MessageDsn messageDsn) {
            this.messageDsn = messageDsn;
            return this;
        }

        public final void setMessageDsn(MessageDsn.BuilderImpl messageDsn) {
            this.messageDsn = messageDsn != null ? messageDsn.build() : null;
        }

        public final Collection<BouncedRecipientInfo.Builder> getBouncedRecipientInfoList() {
            return this.bouncedRecipientInfoList != null ? (Collection)this.bouncedRecipientInfoList.stream().map(BouncedRecipientInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bouncedRecipientInfoList(Collection<BouncedRecipientInfo> bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList = BouncedRecipientInfoListCopier.copy(bouncedRecipientInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bouncedRecipientInfoList(BouncedRecipientInfo ... bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList(Arrays.asList(bouncedRecipientInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bouncedRecipientInfoList(Consumer<BouncedRecipientInfo.Builder> ... bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList(Stream.of(bouncedRecipientInfoList).map(c -> (BouncedRecipientInfo)((BouncedRecipientInfo.Builder)BouncedRecipientInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBouncedRecipientInfoList(Collection<BouncedRecipientInfo.BuilderImpl> bouncedRecipientInfoList) {
            this.bouncedRecipientInfoList = BouncedRecipientInfoListCopier.copyFromBuilder(bouncedRecipientInfoList);
        }

        public final String getBounceSenderArn() {
            return this.bounceSenderArn;
        }

        @Override
        public final Builder bounceSenderArn(String bounceSenderArn) {
            this.bounceSenderArn = bounceSenderArn;
            return this;
        }

        public final void setBounceSenderArn(String bounceSenderArn) {
            this.bounceSenderArn = bounceSenderArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendBounceRequest build() {
            return new SendBounceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendBounceRequest> {
        public Builder originalMessageId(String var1);

        public Builder bounceSender(String var1);

        public Builder explanation(String var1);

        public Builder messageDsn(MessageDsn var1);

        default public Builder messageDsn(Consumer<MessageDsn.Builder> messageDsn) {
            return this.messageDsn((MessageDsn)((MessageDsn.Builder)MessageDsn.builder().applyMutation(messageDsn)).build());
        }

        public Builder bouncedRecipientInfoList(Collection<BouncedRecipientInfo> var1);

        public Builder bouncedRecipientInfoList(BouncedRecipientInfo ... var1);

        public Builder bouncedRecipientInfoList(Consumer<BouncedRecipientInfo.Builder> ... var1);

        public Builder bounceSenderArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

