/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.AddressListCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVerifiedEmailAddressesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, ListVerifiedEmailAddressesResponse> {
    private static final SdkField<List<String>> VERIFIED_EMAIL_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListVerifiedEmailAddressesResponse.getter(ListVerifiedEmailAddressesResponse::verifiedEmailAddresses)).setter(ListVerifiedEmailAddressesResponse.setter(Builder::verifiedEmailAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedEmailAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_EMAIL_ADDRESSES_FIELD));
    private final List<String> verifiedEmailAddresses;

    private ListVerifiedEmailAddressesResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedEmailAddresses = builder.verifiedEmailAddresses;
    }

    public List<String> verifiedEmailAddresses() {
        return this.verifiedEmailAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedEmailAddresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVerifiedEmailAddressesResponse)) {
            return false;
        }
        ListVerifiedEmailAddressesResponse other = (ListVerifiedEmailAddressesResponse)((Object)obj);
        return Objects.equals(this.verifiedEmailAddresses(), other.verifiedEmailAddresses());
    }

    public String toString() {
        return ToString.builder((String)"ListVerifiedEmailAddressesResponse").add("VerifiedEmailAddresses", this.verifiedEmailAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedEmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.verifiedEmailAddresses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVerifiedEmailAddressesResponse, T> g) {
        return obj -> g.apply((ListVerifiedEmailAddressesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<String> verifiedEmailAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVerifiedEmailAddressesResponse model) {
            super(model);
            this.verifiedEmailAddresses(model.verifiedEmailAddresses);
        }

        public final Collection<String> getVerifiedEmailAddresses() {
            return this.verifiedEmailAddresses;
        }

        @Override
        public final Builder verifiedEmailAddresses(Collection<String> verifiedEmailAddresses) {
            this.verifiedEmailAddresses = AddressListCopier.copy(verifiedEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedEmailAddresses(String ... verifiedEmailAddresses) {
            this.verifiedEmailAddresses(Arrays.asList(verifiedEmailAddresses));
            return this;
        }

        public final void setVerifiedEmailAddresses(Collection<String> verifiedEmailAddresses) {
            this.verifiedEmailAddresses = AddressListCopier.copy(verifiedEmailAddresses);
        }

        @Override
        public ListVerifiedEmailAddressesResponse build() {
            return new ListVerifiedEmailAddressesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVerifiedEmailAddressesResponse> {
        public Builder verifiedEmailAddresses(Collection<String> var1);

        public Builder verifiedEmailAddresses(String ... var1);
    }
}

