/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplate;
import software.amazon.awssdk.services.ses.model.CustomVerificationEmailTemplatesCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomVerificationEmailTemplatesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, ListCustomVerificationEmailTemplatesResponse> {
    private static final SdkField<List<CustomVerificationEmailTemplate>> CUSTOM_VERIFICATION_EMAIL_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListCustomVerificationEmailTemplatesResponse.getter(ListCustomVerificationEmailTemplatesResponse::customVerificationEmailTemplates)).setter(ListCustomVerificationEmailTemplatesResponse.setter(Builder::customVerificationEmailTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomVerificationEmailTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomVerificationEmailTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListCustomVerificationEmailTemplatesResponse.getter(ListCustomVerificationEmailTemplatesResponse::nextToken)).setter(ListCustomVerificationEmailTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_VERIFICATION_EMAIL_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CustomVerificationEmailTemplate> customVerificationEmailTemplates;
    private final String nextToken;

    private ListCustomVerificationEmailTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.customVerificationEmailTemplates = builder.customVerificationEmailTemplates;
        this.nextToken = builder.nextToken;
    }

    public List<CustomVerificationEmailTemplate> customVerificationEmailTemplates() {
        return this.customVerificationEmailTemplates;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customVerificationEmailTemplates());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomVerificationEmailTemplatesResponse)) {
            return false;
        }
        ListCustomVerificationEmailTemplatesResponse other = (ListCustomVerificationEmailTemplatesResponse)((Object)obj);
        return Objects.equals(this.customVerificationEmailTemplates(), other.customVerificationEmailTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCustomVerificationEmailTemplatesResponse").add("CustomVerificationEmailTemplates", this.customVerificationEmailTemplates()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomVerificationEmailTemplates": {
                return Optional.ofNullable(clazz.cast(this.customVerificationEmailTemplates()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomVerificationEmailTemplatesResponse, T> g) {
        return obj -> g.apply((ListCustomVerificationEmailTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<CustomVerificationEmailTemplate> customVerificationEmailTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomVerificationEmailTemplatesResponse model) {
            super(model);
            this.customVerificationEmailTemplates(model.customVerificationEmailTemplates);
            this.nextToken(model.nextToken);
        }

        public final Collection<CustomVerificationEmailTemplate.Builder> getCustomVerificationEmailTemplates() {
            return this.customVerificationEmailTemplates != null ? (Collection)this.customVerificationEmailTemplates.stream().map(CustomVerificationEmailTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customVerificationEmailTemplates(Collection<CustomVerificationEmailTemplate> customVerificationEmailTemplates) {
            this.customVerificationEmailTemplates = CustomVerificationEmailTemplatesCopier.copy(customVerificationEmailTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVerificationEmailTemplates(CustomVerificationEmailTemplate ... customVerificationEmailTemplates) {
            this.customVerificationEmailTemplates(Arrays.asList(customVerificationEmailTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customVerificationEmailTemplates(Consumer<CustomVerificationEmailTemplate.Builder> ... customVerificationEmailTemplates) {
            this.customVerificationEmailTemplates(Stream.of(customVerificationEmailTemplates).map(c -> (CustomVerificationEmailTemplate)((CustomVerificationEmailTemplate.Builder)CustomVerificationEmailTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomVerificationEmailTemplates(Collection<CustomVerificationEmailTemplate.BuilderImpl> customVerificationEmailTemplates) {
            this.customVerificationEmailTemplates = CustomVerificationEmailTemplatesCopier.copyFromBuilder(customVerificationEmailTemplates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCustomVerificationEmailTemplatesResponse build() {
            return new ListCustomVerificationEmailTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomVerificationEmailTemplatesResponse> {
        public Builder customVerificationEmailTemplates(Collection<CustomVerificationEmailTemplate> var1);

        public Builder customVerificationEmailTemplates(CustomVerificationEmailTemplate ... var1);

        public Builder customVerificationEmailTemplates(Consumer<CustomVerificationEmailTemplate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

