/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BulkEmailStatus {
    SUCCESS("Success"),
    MESSAGE_REJECTED("MessageRejected"),
    MAIL_FROM_DOMAIN_NOT_VERIFIED("MailFromDomainNotVerified"),
    CONFIGURATION_SET_DOES_NOT_EXIST("ConfigurationSetDoesNotExist"),
    TEMPLATE_DOES_NOT_EXIST("TemplateDoesNotExist"),
    ACCOUNT_SUSPENDED("AccountSuspended"),
    ACCOUNT_THROTTLED("AccountThrottled"),
    ACCOUNT_DAILY_QUOTA_EXCEEDED("AccountDailyQuotaExceeded"),
    INVALID_SENDING_POOL_NAME("InvalidSendingPoolName"),
    ACCOUNT_SENDING_PAUSED("AccountSendingPaused"),
    CONFIGURATION_SET_SENDING_PAUSED("ConfigurationSetSendingPaused"),
    INVALID_PARAMETER_VALUE("InvalidParameterValue"),
    TRANSIENT_FAILURE("TransientFailure"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BulkEmailStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BulkEmailStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BulkEmailStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BulkEmailStatus> knownValues() {
        return Stream.of(BulkEmailStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

