/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.DimensionValueSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchDimensionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionName").getter(CloudWatchDimensionConfiguration.getter(CloudWatchDimensionConfiguration::dimensionName)).setter(CloudWatchDimensionConfiguration.setter(Builder::dimensionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()}).build();
    private static final SdkField<String> DIMENSION_VALUE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionValueSource").getter(CloudWatchDimensionConfiguration.getter(CloudWatchDimensionConfiguration::dimensionValueSourceAsString)).setter(CloudWatchDimensionConfiguration.setter(Builder::dimensionValueSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueSource").build()}).build();
    private static final SdkField<String> DEFAULT_DIMENSION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultDimensionValue").getter(CloudWatchDimensionConfiguration.getter(CloudWatchDimensionConfiguration::defaultDimensionValue)).setter(CloudWatchDimensionConfiguration.setter(Builder::defaultDimensionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultDimensionValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD, DIMENSION_VALUE_SOURCE_FIELD, DEFAULT_DIMENSION_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudWatchDimensionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dimensionName;
    private final String dimensionValueSource;
    private final String defaultDimensionValue;

    private CloudWatchDimensionConfiguration(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueSource = builder.dimensionValueSource;
        this.defaultDimensionValue = builder.defaultDimensionValue;
    }

    public final String dimensionName() {
        return this.dimensionName;
    }

    public final DimensionValueSource dimensionValueSource() {
        return DimensionValueSource.fromValue(this.dimensionValueSource);
    }

    public final String dimensionValueSourceAsString() {
        return this.dimensionValueSource;
    }

    public final String defaultDimensionValue() {
        return this.defaultDimensionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionValueSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDimensionValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDimensionConfiguration)) {
            return false;
        }
        CloudWatchDimensionConfiguration other = (CloudWatchDimensionConfiguration)obj;
        return Objects.equals(this.dimensionName(), other.dimensionName()) && Objects.equals(this.dimensionValueSourceAsString(), other.dimensionValueSourceAsString()) && Objects.equals(this.defaultDimensionValue(), other.defaultDimensionValue());
    }

    public final String toString() {
        return ToString.builder((String)"CloudWatchDimensionConfiguration").add("DimensionName", (Object)this.dimensionName()).add("DimensionValueSource", (Object)this.dimensionValueSourceAsString()).add("DefaultDimensionValue", (Object)this.defaultDimensionValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionName": {
                return Optional.ofNullable(clazz.cast(this.dimensionName()));
            }
            case "DimensionValueSource": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueSourceAsString()));
            }
            case "DefaultDimensionValue": {
                return Optional.ofNullable(clazz.cast(this.defaultDimensionValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DimensionName", DIMENSION_NAME_FIELD);
        map.put("DimensionValueSource", DIMENSION_VALUE_SOURCE_FIELD);
        map.put("DefaultDimensionValue", DEFAULT_DIMENSION_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchDimensionConfiguration, T> g) {
        return obj -> g.apply((CloudWatchDimensionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionName;
        private String dimensionValueSource;
        private String defaultDimensionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDimensionConfiguration model) {
            this.dimensionName(model.dimensionName);
            this.dimensionValueSource(model.dimensionValueSource);
            this.defaultDimensionValue(model.defaultDimensionValue);
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final String getDimensionValueSource() {
            return this.dimensionValueSource;
        }

        public final void setDimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
        }

        @Override
        public final Builder dimensionValueSource(String dimensionValueSource) {
            this.dimensionValueSource = dimensionValueSource;
            return this;
        }

        @Override
        public final Builder dimensionValueSource(DimensionValueSource dimensionValueSource) {
            this.dimensionValueSource(dimensionValueSource == null ? null : dimensionValueSource.toString());
            return this;
        }

        public final String getDefaultDimensionValue() {
            return this.defaultDimensionValue;
        }

        public final void setDefaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
        }

        @Override
        public final Builder defaultDimensionValue(String defaultDimensionValue) {
            this.defaultDimensionValue = defaultDimensionValue;
            return this;
        }

        public CloudWatchDimensionConfiguration build() {
            return new CloudWatchDimensionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchDimensionConfiguration> {
        public Builder dimensionName(String var1);

        public Builder dimensionValueSource(String var1);

        public Builder dimensionValueSource(DimensionValueSource var1);

        public Builder defaultDimensionValue(String var1);
    }
}

