/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.IdentityListCopier;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityDkimAttributesRequest
extends SesRequest
implements ToCopyableBuilder<Builder, GetIdentityDkimAttributesRequest> {
    private static final SdkField<List<String>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identities").getter(GetIdentityDkimAttributesRequest.getter(GetIdentityDkimAttributesRequest::identities)).setter(GetIdentityDkimAttributesRequest.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Identities", IDENTITIES_FIELD);
        }
    });
    private final List<String> identities;

    private GetIdentityDkimAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.identities = builder.identities;
    }

    public final boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructList);
    }

    public final List<String> identities() {
        return this.identities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityDkimAttributesRequest)) {
            return false;
        }
        GetIdentityDkimAttributesRequest other = (GetIdentityDkimAttributesRequest)((Object)obj);
        return this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityDkimAttributesRequest").add("Identities", this.hasIdentities() ? this.identities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityDkimAttributesRequest, T> g) {
        return obj -> g.apply((GetIdentityDkimAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private List<String> identities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityDkimAttributesRequest model) {
            super(model);
            this.identities(model.identities);
        }

        public final Collection<String> getIdentities() {
            if (this.identities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identities;
        }

        public final void setIdentities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
        }

        @Override
        public final Builder identities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(String ... identities) {
            this.identities(Arrays.asList(identities));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIdentityDkimAttributesRequest build() {
            return new GetIdentityDkimAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityDkimAttributesRequest> {
        public Builder identities(Collection<String> var1);

        public Builder identities(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

