/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetReceiptRulePositionRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SetReceiptRulePositionRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetReceiptRulePositionRequest.getter(SetReceiptRulePositionRequest::ruleSetName)).setter(SetReceiptRulePositionRequest.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetReceiptRulePositionRequest.getter(SetReceiptRulePositionRequest::ruleName)).setter(SetReceiptRulePositionRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetReceiptRulePositionRequest.getter(SetReceiptRulePositionRequest::after)).setter(SetReceiptRulePositionRequest.setter(Builder::after)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("After").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD, RULE_NAME_FIELD, AFTER_FIELD));
    private final String ruleSetName;
    private final String ruleName;
    private final String after;

    private SetReceiptRulePositionRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
        this.after = builder.after;
    }

    public String ruleSetName() {
        return this.ruleSetName;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public String after() {
        return this.after;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.after());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetReceiptRulePositionRequest)) {
            return false;
        }
        SetReceiptRulePositionRequest other = (SetReceiptRulePositionRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.after(), other.after());
    }

    public String toString() {
        return ToString.builder((String)"SetReceiptRulePositionRequest").add("RuleSetName", (Object)this.ruleSetName()).add("RuleName", (Object)this.ruleName()).add("After", (Object)this.after()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "After": {
                return Optional.ofNullable(clazz.cast(this.after()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetReceiptRulePositionRequest, T> g) {
        return obj -> g.apply((SetReceiptRulePositionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String ruleName;
        private String after;

        private BuilderImpl() {
        }

        private BuilderImpl(SetReceiptRulePositionRequest model) {
            super(model);
            this.ruleSetName(model.ruleSetName);
            this.ruleName(model.ruleName);
            this.after(model.after);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final String getAfter() {
            return this.after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetReceiptRulePositionRequest build() {
            return new SetReceiptRulePositionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetReceiptRulePositionRequest> {
        public Builder ruleSetName(String var1);

        public Builder ruleName(String var1);

        public Builder after(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

