/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicediscovery.model.AttributesCopier;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterInstanceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, RegisterInstanceRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::serviceId)).setter(RegisterInstanceRequest.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::instanceId)).setter(RegisterInstanceRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::creatorRequestId)).setter(RegisterInstanceRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(RegisterInstanceRequest.getter(RegisterInstanceRequest::attributes)).setter(RegisterInstanceRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD, INSTANCE_ID_FIELD, CREATOR_REQUEST_ID_FIELD, ATTRIBUTES_FIELD));
    private final String serviceId;
    private final String instanceId;
    private final String creatorRequestId;
    private final Map<String, String> attributes;

    private RegisterInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.instanceId = builder.instanceId;
        this.creatorRequestId = builder.creatorRequestId;
        this.attributes = builder.attributes;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterInstanceRequest)) {
            return false;
        }
        RegisterInstanceRequest other = (RegisterInstanceRequest)((Object)obj);
        return Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"RegisterInstanceRequest").add("ServiceId", (Object)this.serviceId()).add("InstanceId", (Object)this.instanceId()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterInstanceRequest, T> g) {
        return obj -> g.apply((RegisterInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String serviceId;
        private String instanceId;
        private String creatorRequestId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterInstanceRequest model) {
            super(model);
            this.serviceId(model.serviceId);
            this.instanceId(model.instanceId);
            this.creatorRequestId(model.creatorRequestId);
            this.attributes(model.attributes);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterInstanceRequest build() {
            return new RegisterInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterInstanceRequest> {
        public Builder serviceId(String var1);

        public Builder instanceId(String var1);

        public Builder creatorRequestId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

