/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationType {
    CREATE_NAMESPACE("CREATE_NAMESPACE"),
    DELETE_NAMESPACE("DELETE_NAMESPACE"),
    UPDATE_NAMESPACE("UPDATE_NAMESPACE"),
    UPDATE_SERVICE("UPDATE_SERVICE"),
    REGISTER_INSTANCE("REGISTER_INSTANCE"),
    DEREGISTER_INSTANCE("DEREGISTER_INSTANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationType> VALUE_MAP;
    private final String value;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationType> knownValues() {
        EnumSet<OperationType> knownValues = EnumSet.allOf(OperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationType.class, OperationType::toString);
    }
}

