/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicediscovery.model.DnsConfig;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckCustomConfig;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.services.servicediscovery.model.Tag;
import software.amazon.awssdk.services.servicediscovery.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateServiceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, CreateServiceRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateServiceRequest.getter(CreateServiceRequest::name)).setter(CreateServiceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamespaceId").getter(CreateServiceRequest.getter(CreateServiceRequest::namespaceId)).setter(CreateServiceRequest.setter(Builder::namespaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceId").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateServiceRequest.getter(CreateServiceRequest::creatorRequestId)).setter(CreateServiceRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateServiceRequest.getter(CreateServiceRequest::description)).setter(CreateServiceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<DnsConfig> DNS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsConfig").getter(CreateServiceRequest.getter(CreateServiceRequest::dnsConfig)).setter(CreateServiceRequest.setter(Builder::dnsConfig)).constructor(DnsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsConfig").build()}).build();
    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheckConfig").getter(CreateServiceRequest.getter(CreateServiceRequest::healthCheckConfig)).setter(CreateServiceRequest.setter(Builder::healthCheckConfig)).constructor(HealthCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfig").build()}).build();
    private static final SdkField<HealthCheckCustomConfig> HEALTH_CHECK_CUSTOM_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheckCustomConfig").getter(CreateServiceRequest.getter(CreateServiceRequest::healthCheckCustomConfig)).setter(CreateServiceRequest.setter(Builder::healthCheckCustomConfig)).constructor(HealthCheckCustomConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckCustomConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateServiceRequest.getter(CreateServiceRequest::tags)).setter(CreateServiceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NAMESPACE_ID_FIELD, CREATOR_REQUEST_ID_FIELD, DESCRIPTION_FIELD, DNS_CONFIG_FIELD, HEALTH_CHECK_CONFIG_FIELD, HEALTH_CHECK_CUSTOM_CONFIG_FIELD, TAGS_FIELD));
    private final String name;
    private final String namespaceId;
    private final String creatorRequestId;
    private final String description;
    private final DnsConfig dnsConfig;
    private final HealthCheckConfig healthCheckConfig;
    private final HealthCheckCustomConfig healthCheckCustomConfig;
    private final List<Tag> tags;

    private CreateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.namespaceId = builder.namespaceId;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.dnsConfig = builder.dnsConfig;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckCustomConfig = builder.healthCheckCustomConfig;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String namespaceId() {
        return this.namespaceId;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String description() {
        return this.description;
    }

    public final DnsConfig dnsConfig() {
        return this.dnsConfig;
    }

    public final HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public final HealthCheckCustomConfig healthCheckCustomConfig() {
        return this.healthCheckCustomConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckCustomConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceRequest)) {
            return false;
        }
        CreateServiceRequest other = (CreateServiceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.namespaceId(), other.namespaceId()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsConfig(), other.dnsConfig()) && Objects.equals(this.healthCheckConfig(), other.healthCheckConfig()) && Objects.equals(this.healthCheckCustomConfig(), other.healthCheckCustomConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateServiceRequest").add("Name", (Object)this.name()).add("NamespaceId", (Object)this.namespaceId()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Description", (Object)this.description()).add("DnsConfig", (Object)this.dnsConfig()).add("HealthCheckConfig", (Object)this.healthCheckConfig()).add("HealthCheckCustomConfig", (Object)this.healthCheckCustomConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "NamespaceId": {
                return Optional.ofNullable(clazz.cast(this.namespaceId()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DnsConfig": {
                return Optional.ofNullable(clazz.cast(this.dnsConfig()));
            }
            case "HealthCheckConfig": {
                return Optional.ofNullable(clazz.cast(this.healthCheckConfig()));
            }
            case "HealthCheckCustomConfig": {
                return Optional.ofNullable(clazz.cast(this.healthCheckCustomConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceRequest, T> g) {
        return obj -> g.apply((CreateServiceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String namespaceId;
        private String creatorRequestId;
        private String description;
        private DnsConfig dnsConfig;
        private HealthCheckConfig healthCheckConfig;
        private HealthCheckCustomConfig healthCheckCustomConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceRequest model) {
            super(model);
            this.name(model.name);
            this.namespaceId(model.namespaceId);
            this.creatorRequestId(model.creatorRequestId);
            this.description(model.description);
            this.dnsConfig(model.dnsConfig);
            this.healthCheckConfig(model.healthCheckConfig);
            this.healthCheckCustomConfig(model.healthCheckCustomConfig);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getNamespaceId() {
            return this.namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DnsConfig.Builder getDnsConfig() {
            return this.dnsConfig != null ? this.dnsConfig.toBuilder() : null;
        }

        @Override
        public final Builder dnsConfig(DnsConfig dnsConfig) {
            this.dnsConfig = dnsConfig;
            return this;
        }

        public final void setDnsConfig(DnsConfig.BuilderImpl dnsConfig) {
            this.dnsConfig = dnsConfig != null ? dnsConfig.build() : null;
        }

        public final HealthCheckConfig.Builder getHealthCheckConfig() {
            return this.healthCheckConfig != null ? this.healthCheckConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig.BuilderImpl healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig != null ? healthCheckConfig.build() : null;
        }

        public final HealthCheckCustomConfig.Builder getHealthCheckCustomConfig() {
            return this.healthCheckCustomConfig != null ? this.healthCheckCustomConfig.toBuilder() : null;
        }

        @Override
        public final Builder healthCheckCustomConfig(HealthCheckCustomConfig healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig;
            return this;
        }

        public final void setHealthCheckCustomConfig(HealthCheckCustomConfig.BuilderImpl healthCheckCustomConfig) {
            this.healthCheckCustomConfig = healthCheckCustomConfig != null ? healthCheckCustomConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServiceRequest build() {
            return new CreateServiceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateServiceRequest> {
        public Builder name(String var1);

        public Builder namespaceId(String var1);

        public Builder creatorRequestId(String var1);

        public Builder description(String var1);

        public Builder dnsConfig(DnsConfig var1);

        default public Builder dnsConfig(Consumer<DnsConfig.Builder> dnsConfig) {
            return this.dnsConfig((DnsConfig)((DnsConfig.Builder)DnsConfig.builder().applyMutation(dnsConfig)).build());
        }

        public Builder healthCheckConfig(HealthCheckConfig var1);

        default public Builder healthCheckConfig(Consumer<HealthCheckConfig.Builder> healthCheckConfig) {
            return this.healthCheckConfig((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().applyMutation(healthCheckConfig)).build());
        }

        public Builder healthCheckCustomConfig(HealthCheckCustomConfig var1);

        default public Builder healthCheckCustomConfig(Consumer<HealthCheckCustomConfig.Builder> healthCheckCustomConfig) {
            return this.healthCheckCustomConfig((HealthCheckCustomConfig)((HealthCheckCustomConfig.Builder)HealthCheckCustomConfig.builder().applyMutation(healthCheckCustomConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

