/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicediscovery.model.AttributesCopier;
import software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInstancesRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, DiscoverInstancesRequest> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::namespaceName)).setter(DiscoverInstancesRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::serviceName)).setter(DiscoverInstancesRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::maxResults)).setter(DiscoverInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Map<String, String>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::queryParameters)).setter(DiscoverInstancesRequest.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::healthStatusAsString)).setter(DiscoverInstancesRequest.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD, SERVICE_NAME_FIELD, MAX_RESULTS_FIELD, QUERY_PARAMETERS_FIELD, HEALTH_STATUS_FIELD));
    private final String namespaceName;
    private final String serviceName;
    private final Integer maxResults;
    private final Map<String, String> queryParameters;
    private final String healthStatus;

    private DiscoverInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
        this.maxResults = builder.maxResults;
        this.queryParameters = builder.queryParameters;
        this.healthStatus = builder.healthStatus;
    }

    public String namespaceName() {
        return this.namespaceName;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Map<String, String> queryParameters() {
        return this.queryParameters;
    }

    public HealthStatusFilter healthStatus() {
        return HealthStatusFilter.fromValue(this.healthStatus);
    }

    public String healthStatusAsString() {
        return this.healthStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesRequest)) {
            return false;
        }
        DiscoverInstancesRequest other = (DiscoverInstancesRequest)((Object)obj);
        return Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.queryParameters(), other.queryParameters()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DiscoverInstancesRequest").add("NamespaceName", (Object)this.namespaceName()).add("ServiceName", (Object)this.serviceName()).add("MaxResults", (Object)this.maxResults()).add("QueryParameters", this.queryParameters()).add("HealthStatus", (Object)this.healthStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesRequest, T> g) {
        return obj -> g.apply((DiscoverInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String namespaceName;
        private String serviceName;
        private Integer maxResults;
        private Map<String, String> queryParameters = DefaultSdkAutoConstructMap.getInstance();
        private String healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesRequest model) {
            super(model);
            this.namespaceName(model.namespaceName);
            this.serviceName(model.serviceName);
            this.maxResults(model.maxResults);
            this.queryParameters(model.queryParameters);
            this.healthStatus(model.healthStatus);
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Map<String, String> getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        public final Builder queryParameters(Map<String, String> queryParameters) {
            this.queryParameters = AttributesCopier.copy(queryParameters);
            return this;
        }

        public final void setQueryParameters(Map<String, String> queryParameters) {
            this.queryParameters = AttributesCopier.copy(queryParameters);
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatusFilter healthStatus) {
            this.healthStatus(healthStatus.toString());
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverInstancesRequest build() {
            return new DiscoverInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverInstancesRequest> {
        public Builder namespaceName(String var1);

        public Builder serviceName(String var1);

        public Builder maxResults(Integer var1);

        public Builder queryParameters(Map<String, String> var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatusFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

