/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StackInstanceStatus {
    CURRENT("CURRENT"),
    OUTDATED("OUTDATED"),
    INOPERABLE("INOPERABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StackInstanceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackInstanceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StackInstanceStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackInstanceStatus> knownValues() {
        return Stream.of(StackInstanceStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

