/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.BudgetDetail;
import software.amazon.awssdk.services.servicecatalog.model.BudgetsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifact;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProductResponse> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeProductResponse.getter(DescribeProductResponse::productViewSummary)).setter(DescribeProductResponse.setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build()}).build();
    private static final SdkField<List<ProvisioningArtifact>> PROVISIONING_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeProductResponse.getter(DescribeProductResponse::provisioningArtifacts)).setter(DescribeProductResponse.setter(Builder::provisioningArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BudgetDetail>> BUDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeProductResponse.getter(DescribeProductResponse::budgets)).setter(DescribeProductResponse.setter(Builder::budgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Budgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD, PROVISIONING_ARTIFACTS_FIELD, BUDGETS_FIELD));
    private final ProductViewSummary productViewSummary;
    private final List<ProvisioningArtifact> provisioningArtifacts;
    private final List<BudgetDetail> budgets;

    private DescribeProductResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummary = builder.productViewSummary;
        this.provisioningArtifacts = builder.provisioningArtifacts;
        this.budgets = builder.budgets;
    }

    public ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public List<ProvisioningArtifact> provisioningArtifacts() {
        return this.provisioningArtifacts;
    }

    public List<BudgetDetail> budgets() {
        return this.budgets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgets());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductResponse)) {
            return false;
        }
        DescribeProductResponse other = (DescribeProductResponse)((Object)obj);
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && Objects.equals(this.provisioningArtifacts(), other.provisioningArtifacts()) && Objects.equals(this.budgets(), other.budgets());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProductResponse").add("ProductViewSummary", (Object)this.productViewSummary()).add("ProvisioningArtifacts", this.provisioningArtifacts()).add("Budgets", this.budgets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.ofNullable(clazz.cast(this.productViewSummary()));
            }
            case "ProvisioningArtifacts": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifacts()));
            }
            case "Budgets": {
                return Optional.ofNullable(clazz.cast(this.budgets()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductResponse, T> g) {
        return obj -> g.apply((DescribeProductResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private List<ProvisioningArtifact> provisioningArtifacts = DefaultSdkAutoConstructList.getInstance();
        private List<BudgetDetail> budgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductResponse model) {
            super(model);
            this.productViewSummary(model.productViewSummary);
            this.provisioningArtifacts(model.provisioningArtifacts);
            this.budgets(model.budgets);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final Collection<ProvisioningArtifact.Builder> getProvisioningArtifacts() {
            return this.provisioningArtifacts != null ? (Collection)this.provisioningArtifacts.stream().map(ProvisioningArtifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningArtifacts(Collection<ProvisioningArtifact> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copy(provisioningArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(ProvisioningArtifact ... provisioningArtifacts) {
            this.provisioningArtifacts(Arrays.asList(provisioningArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder> ... provisioningArtifacts) {
            this.provisioningArtifacts(Stream.of(provisioningArtifacts).map(c -> (ProvisioningArtifact)((ProvisioningArtifact.Builder)ProvisioningArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningArtifacts(Collection<ProvisioningArtifact.BuilderImpl> provisioningArtifacts) {
            this.provisioningArtifacts = ProvisioningArtifactsCopier.copyFromBuilder(provisioningArtifacts);
        }

        public final Collection<BudgetDetail.Builder> getBudgets() {
            return this.budgets != null ? (Collection)this.budgets.stream().map(BudgetDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder budgets(Collection<BudgetDetail> budgets) {
            this.budgets = BudgetsCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetDetail ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetDetail.Builder> ... budgets) {
            this.budgets(Stream.of(budgets).map(c -> (BudgetDetail)((BudgetDetail.Builder)BudgetDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBudgets(Collection<BudgetDetail.BuilderImpl> budgets) {
            this.budgets = BudgetsCopier.copyFromBuilder(budgets);
        }

        @Override
        public DescribeProductResponse build() {
            return new DescribeProductResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProductResponse> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation(productViewSummary)).build());
        }

        public Builder provisioningArtifacts(Collection<ProvisioningArtifact> var1);

        public Builder provisioningArtifacts(ProvisioningArtifact ... var1);

        public Builder provisioningArtifacts(Consumer<ProvisioningArtifact.Builder> ... var1);

        public Builder budgets(Collection<BudgetDetail> var1);

        public Builder budgets(BudgetDetail ... var1);

        public Builder budgets(Consumer<BudgetDetail.Builder> ... var1);
    }
}

