/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServiceActionsForProvisioningArtifactResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListServiceActionsForProvisioningArtifactResponse> {
    private static final SdkField<List<ServiceActionSummary>> SERVICE_ACTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListServiceActionsForProvisioningArtifactResponse.getter(ListServiceActionsForProvisioningArtifactResponse::serviceActionSummaries)).setter(ListServiceActionsForProvisioningArtifactResponse.setter(Builder::serviceActionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceActionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceActionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListServiceActionsForProvisioningArtifactResponse.getter(ListServiceActionsForProvisioningArtifactResponse::nextPageToken)).setter(ListServiceActionsForProvisioningArtifactResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ACTION_SUMMARIES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<ServiceActionSummary> serviceActionSummaries;
    private final String nextPageToken;

    private ListServiceActionsForProvisioningArtifactResponse(BuilderImpl builder) {
        super(builder);
        this.serviceActionSummaries = builder.serviceActionSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ServiceActionSummary> serviceActionSummaries() {
        return this.serviceActionSummaries;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceActionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceActionsForProvisioningArtifactResponse)) {
            return false;
        }
        ListServiceActionsForProvisioningArtifactResponse other = (ListServiceActionsForProvisioningArtifactResponse)((Object)obj);
        return Objects.equals(this.serviceActionSummaries(), other.serviceActionSummaries()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListServiceActionsForProvisioningArtifactResponse").add("ServiceActionSummaries", this.serviceActionSummaries()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceActionSummaries": {
                return Optional.ofNullable(clazz.cast(this.serviceActionSummaries()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceActionsForProvisioningArtifactResponse, T> g) {
        return obj -> g.apply((ListServiceActionsForProvisioningArtifactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ServiceActionSummary> serviceActionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceActionsForProvisioningArtifactResponse model) {
            super(model);
            this.serviceActionSummaries(model.serviceActionSummaries);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ServiceActionSummary.Builder> getServiceActionSummaries() {
            return this.serviceActionSummaries != null ? (Collection)this.serviceActionSummaries.stream().map(ServiceActionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceActionSummaries(Collection<ServiceActionSummary> serviceActionSummaries) {
            this.serviceActionSummaries = ServiceActionSummariesCopier.copy(serviceActionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionSummaries(ServiceActionSummary ... serviceActionSummaries) {
            this.serviceActionSummaries(Arrays.asList(serviceActionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceActionSummaries(Consumer<ServiceActionSummary.Builder> ... serviceActionSummaries) {
            this.serviceActionSummaries(Stream.of(serviceActionSummaries).map(c -> (ServiceActionSummary)((ServiceActionSummary.Builder)ServiceActionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceActionSummaries(Collection<ServiceActionSummary.BuilderImpl> serviceActionSummaries) {
            this.serviceActionSummaries = ServiceActionSummariesCopier.copyFromBuilder(serviceActionSummaries);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListServiceActionsForProvisioningArtifactResponse build() {
            return new ListServiceActionsForProvisioningArtifactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServiceActionsForProvisioningArtifactResponse> {
        public Builder serviceActionSummaries(Collection<ServiceActionSummary> var1);

        public Builder serviceActionSummaries(ServiceActionSummary ... var1);

        public Builder serviceActionSummaries(Consumer<ServiceActionSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

