/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ProductSource;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFiltersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProductsAsAdminRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, SearchProductsAsAdminRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::acceptLanguage)).setter(SearchProductsAsAdminRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::portfolioId)).setter(SearchProductsAsAdminRequest.setter(Builder::portfolioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::filtersAsStrings)).setter(SearchProductsAsAdminRequest.setter(Builder::filtersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::sortByAsString)).setter(SearchProductsAsAdminRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::sortOrderAsString)).setter(SearchProductsAsAdminRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::pageToken)).setter(SearchProductsAsAdminRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::pageSize)).setter(SearchProductsAsAdminRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PRODUCT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SearchProductsAsAdminRequest.getter(SearchProductsAsAdminRequest::productSourceAsString)).setter(SearchProductsAsAdminRequest.setter(Builder::productSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PORTFOLIO_ID_FIELD, FILTERS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, PRODUCT_SOURCE_FIELD));
    private final String acceptLanguage;
    private final String portfolioId;
    private final Map<String, List<String>> filters;
    private final String sortBy;
    private final String sortOrder;
    private final String pageToken;
    private final Integer pageSize;
    private final String productSource;

    private SearchProductsAsAdminRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
        this.productSource = builder.productSource;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public Map<ProductViewFilterBy, List<String>> filters() {
        return ProductViewFiltersCopier.copyStringToEnum(this.filters);
    }

    public Map<String, List<String>> filtersAsStrings() {
        return this.filters;
    }

    public ProductViewSortBy sortBy() {
        return ProductViewSortBy.fromValue(this.sortBy);
    }

    public String sortByAsString() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderAsString() {
        return this.sortOrder;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public ProductSource productSource() {
        return ProductSource.fromValue(this.productSource);
    }

    public String productSourceAsString() {
        return this.productSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filtersAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.productSourceAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminRequest)) {
            return false;
        }
        SearchProductsAsAdminRequest other = (SearchProductsAsAdminRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.filtersAsStrings(), other.filtersAsStrings()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.productSourceAsString(), other.productSourceAsString());
    }

    public String toString() {
        return ToString.builder((String)"SearchProductsAsAdminRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("PortfolioId", (Object)this.portfolioId()).add("Filters", this.filtersAsStrings()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("PageToken", (Object)this.pageToken()).add("PageSize", (Object)this.pageSize()).add("ProductSource", (Object)this.productSourceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.ofNullable(clazz.cast(this.portfolioId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filtersAsStrings()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "ProductSource": {
                return Optional.ofNullable(clazz.cast(this.productSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchProductsAsAdminRequest, T> g) {
        return obj -> g.apply((SearchProductsAsAdminRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private Map<String, List<String>> filters = DefaultSdkAutoConstructMap.getInstance();
        private String sortBy;
        private String sortOrder;
        private String pageToken;
        private Integer pageSize;
        private String productSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.filtersWithStrings(model.filters);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.pageToken(model.pageToken);
            this.pageSize(model.pageSize);
            this.productSource(model.productSource);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final Map<String, ? extends Collection<String>> getFiltersAsStrings() {
            return this.filters;
        }

        @Override
        public final Builder filtersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
            return this;
        }

        @Override
        public final Builder filters(Map<ProductViewFilterBy, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copyEnumToString(filters);
            return this;
        }

        public final void setFiltersWithStrings(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
        }

        public final String getSortByAsString() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ProductViewSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrderAsString() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getProductSourceAsString() {
            return this.productSource;
        }

        @Override
        public final Builder productSource(String productSource) {
            this.productSource = productSource;
            return this;
        }

        @Override
        public final Builder productSource(ProductSource productSource) {
            this.productSource(productSource.toString());
            return this;
        }

        public final void setProductSource(String productSource) {
            this.productSource = productSource;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchProductsAsAdminRequest build() {
            return new SearchProductsAsAdminRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchProductsAsAdminRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder filtersWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder filters(Map<ProductViewFilterBy, ? extends Collection<String>> var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ProductViewSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder productSource(String var1);

        public Builder productSource(ProductSource var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

