/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.NotificationArnsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningParameter;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningParametersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningPreferences;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ProvisionProductRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionProductRequest.getter(ProvisionProductRequest::acceptLanguage)).setter(ProvisionProductRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionProductRequest.getter(ProvisionProductRequest::productId)).setter(ProvisionProductRequest.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningArtifactId)).setter(ProvisionProductRequest.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionProductRequest.getter(ProvisionProductRequest::pathId)).setter(ProvisionProductRequest.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<String> PROVISIONED_PRODUCT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisionedProductName)).setter(ProvisionProductRequest.setter(Builder::provisionedProductName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedProductName").build()}).build();
    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningParameters)).setter(ProvisionProductRequest.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisioningPreferences> PROVISIONING_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisioningPreferences)).setter(ProvisionProductRequest.setter(Builder::provisioningPreferences)).constructor(ProvisioningPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningPreferences").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProvisionProductRequest.getter(ProvisionProductRequest::tags)).setter(ProvisionProductRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProvisionProductRequest.getter(ProvisionProductRequest::notificationArns)).setter(ProvisionProductRequest.setter(Builder::notificationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVISION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvisionProductRequest.getter(ProvisionProductRequest::provisionToken)).setter(ProvisionProductRequest.setter(Builder::provisionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PATH_ID_FIELD, PROVISIONED_PRODUCT_NAME_FIELD, PROVISIONING_PARAMETERS_FIELD, PROVISIONING_PREFERENCES_FIELD, TAGS_FIELD, NOTIFICATION_ARNS_FIELD, PROVISION_TOKEN_FIELD));
    private final String acceptLanguage;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final String provisionedProductName;
    private final List<ProvisioningParameter> provisioningParameters;
    private final ProvisioningPreferences provisioningPreferences;
    private final List<Tag> tags;
    private final List<String> notificationArns;
    private final String provisionToken;

    private ProvisionProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisionedProductName = builder.provisionedProductName;
        this.provisioningParameters = builder.provisioningParameters;
        this.provisioningPreferences = builder.provisioningPreferences;
        this.tags = builder.tags;
        this.notificationArns = builder.notificationArns;
        this.provisionToken = builder.provisionToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String productId() {
        return this.productId;
    }

    public String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public String pathId() {
        return this.pathId;
    }

    public String provisionedProductName() {
        return this.provisionedProductName;
    }

    public List<ProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public ProvisioningPreferences provisioningPreferences() {
        return this.provisioningPreferences;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> notificationArns() {
        return this.notificationArns;
    }

    public String provisionToken() {
        return this.provisionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionProductRequest)) {
            return false;
        }
        ProvisionProductRequest other = (ProvisionProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.pathId(), other.pathId()) && Objects.equals(this.provisionedProductName(), other.provisionedProductName()) && Objects.equals(this.provisioningParameters(), other.provisioningParameters()) && Objects.equals(this.provisioningPreferences(), other.provisioningPreferences()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.notificationArns(), other.notificationArns()) && Objects.equals(this.provisionToken(), other.provisionToken());
    }

    public String toString() {
        return ToString.builder((String)"ProvisionProductRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("PathId", (Object)this.pathId()).add("ProvisionedProductName", (Object)this.provisionedProductName()).add("ProvisioningParameters", this.provisioningParameters()).add("ProvisioningPreferences", (Object)this.provisioningPreferences()).add("Tags", this.tags()).add("NotificationArns", this.notificationArns()).add("ProvisionToken", (Object)this.provisionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "ProvisionedProductName": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductName()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
            case "ProvisioningPreferences": {
                return Optional.ofNullable(clazz.cast(this.provisioningPreferences()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "NotificationArns": {
                return Optional.ofNullable(clazz.cast(this.notificationArns()));
            }
            case "ProvisionToken": {
                return Optional.ofNullable(clazz.cast(this.provisionToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionProductRequest, T> g) {
        return obj -> g.apply((ProvisionProductRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private String provisionedProductName;
        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();
        private ProvisioningPreferences provisioningPreferences;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> notificationArns = DefaultSdkAutoConstructList.getInstance();
        private String provisionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionProductRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pathId(model.pathId);
            this.provisionedProductName(model.provisionedProductName);
            this.provisioningParameters(model.provisioningParameters);
            this.provisioningPreferences(model.provisioningPreferences);
            this.tags(model.tags);
            this.notificationArns(model.notificationArns);
            this.provisionToken(model.provisionToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final String getProvisionedProductName() {
            return this.provisionedProductName;
        }

        @Override
        public final Builder provisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
            return this;
        }

        public final void setProvisionedProductName(String provisionedProductName) {
            this.provisionedProductName = provisionedProductName;
        }

        public final Collection<ProvisioningParameter.Builder> getProvisioningParameters() {
            return this.provisioningParameters != null ? (Collection)this.provisioningParameters.stream().map(ProvisioningParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (ProvisioningParameter)((ProvisioningParameter.Builder)ProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public final ProvisioningPreferences.Builder getProvisioningPreferences() {
            return this.provisioningPreferences != null ? this.provisioningPreferences.toBuilder() : null;
        }

        @Override
        public final Builder provisioningPreferences(ProvisioningPreferences provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences;
            return this;
        }

        public final void setProvisioningPreferences(ProvisioningPreferences.BuilderImpl provisioningPreferences) {
            this.provisioningPreferences = provisioningPreferences != null ? provisioningPreferences.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final Builder notificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationArns(String ... notificationArns) {
            this.notificationArns(Arrays.asList(notificationArns));
            return this;
        }

        public final void setNotificationArns(Collection<String> notificationArns) {
            this.notificationArns = NotificationArnsCopier.copy(notificationArns);
        }

        public final String getProvisionToken() {
            return this.provisionToken;
        }

        @Override
        public final Builder provisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
            return this;
        }

        public final void setProvisionToken(String provisionToken) {
            this.provisionToken = provisionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionProductRequest build() {
            return new ProvisionProductRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder provisionedProductName(String var1);

        public Builder provisioningParameters(Collection<ProvisioningParameter> var1);

        public Builder provisioningParameters(ProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... var1);

        public Builder provisioningPreferences(ProvisioningPreferences var1);

        default public Builder provisioningPreferences(Consumer<ProvisioningPreferences.Builder> provisioningPreferences) {
            return this.provisioningPreferences((ProvisioningPreferences)((ProvisioningPreferences.Builder)ProvisioningPreferences.builder().applyMutation(provisioningPreferences)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder notificationArns(Collection<String> var1);

        public Builder notificationArns(String ... var1);

        public Builder provisionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

