/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionKey;
import software.amazon.awssdk.services.servicecatalog.model.ServiceActionDefinitionMapCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceActionRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateServiceActionRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateServiceActionRequest.getter(UpdateServiceActionRequest::id)).setter(UpdateServiceActionRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateServiceActionRequest.getter(UpdateServiceActionRequest::name)).setter(UpdateServiceActionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, String>> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Definition").getter(UpdateServiceActionRequest.getter(UpdateServiceActionRequest::definitionAsStrings)).setter(UpdateServiceActionRequest.setter(Builder::definitionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateServiceActionRequest.getter(UpdateServiceActionRequest::description)).setter(UpdateServiceActionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcceptLanguage").getter(UpdateServiceActionRequest.getter(UpdateServiceActionRequest::acceptLanguage)).setter(UpdateServiceActionRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, DEFINITION_FIELD, DESCRIPTION_FIELD, ACCEPT_LANGUAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceActionRequest.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final Map<String, String> definition;
    private final String description;
    private final String acceptLanguage;

    private UpdateServiceActionRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.definition = builder.definition;
        this.description = builder.description;
        this.acceptLanguage = builder.acceptLanguage;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final Map<ServiceActionDefinitionKey, String> definition() {
        return ServiceActionDefinitionMapCopier.copyStringToEnum(this.definition);
    }

    public final boolean hasDefinition() {
        return this.definition != null && !(this.definition instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> definitionAsStrings() {
        return this.definition;
    }

    public final String description() {
        return this.description;
    }

    public final String acceptLanguage() {
        return this.acceptLanguage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefinition() ? this.definitionAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceActionRequest)) {
            return false;
        }
        UpdateServiceActionRequest other = (UpdateServiceActionRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && this.hasDefinition() == other.hasDefinition() && Objects.equals(this.definitionAsStrings(), other.definitionAsStrings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.acceptLanguage(), other.acceptLanguage());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceActionRequest").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Definition", this.hasDefinition() ? this.definitionAsStrings() : null).add("Description", (Object)this.description()).add("AcceptLanguage", (Object)this.acceptLanguage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definitionAsStrings()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Definition", DEFINITION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AcceptLanguage", ACCEPT_LANGUAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceActionRequest, T> g) {
        return obj -> g.apply((UpdateServiceActionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private Map<String, String> definition = DefaultSdkAutoConstructMap.getInstance();
        private String description;
        private String acceptLanguage;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceActionRequest model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.definitionWithStrings(model.definition);
            this.description(model.description);
            this.acceptLanguage(model.acceptLanguage);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getDefinition() {
            if (this.definition instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.definition;
        }

        public final void setDefinition(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
        }

        @Override
        public final Builder definitionWithStrings(Map<String, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copy(definition);
            return this;
        }

        @Override
        public final Builder definition(Map<ServiceActionDefinitionKey, String> definition) {
            this.definition = ServiceActionDefinitionMapCopier.copyEnumToString(definition);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceActionRequest build() {
            return new UpdateServiceActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceActionRequest> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder definitionWithStrings(Map<String, String> var1);

        public Builder definition(Map<ServiceActionDefinitionKey, String> var1);

        public Builder description(String var1);

        public Builder acceptLanguage(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

