/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowResourceIdentifier;
import software.amazon.awssdk.services.servicecatalog.model.EngineWorkflowStatus;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutputsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyProvisionProductEngineWorkflowResultRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, NotifyProvisionProductEngineWorkflowResultRequest> {
    private static final SdkField<String> WORKFLOW_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowToken").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::workflowToken)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::workflowToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowToken").build()}).build();
    private static final SdkField<String> RECORD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordId").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::recordId)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::recordId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::statusAsString)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::failureReason)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<EngineWorkflowResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceIdentifier").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::resourceIdentifier)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::resourceIdentifier)).constructor(EngineWorkflowResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<List<RecordOutput>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Outputs").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::outputs)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecordOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(NotifyProvisionProductEngineWorkflowResultRequest.getter(NotifyProvisionProductEngineWorkflowResultRequest::idempotencyToken)).setter(NotifyProvisionProductEngineWorkflowResultRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_TOKEN_FIELD, RECORD_ID_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, RESOURCE_IDENTIFIER_FIELD, OUTPUTS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotifyProvisionProductEngineWorkflowResultRequest.memberNameToFieldInitializer();
    private final String workflowToken;
    private final String recordId;
    private final String status;
    private final String failureReason;
    private final EngineWorkflowResourceIdentifier resourceIdentifier;
    private final List<RecordOutput> outputs;
    private final String idempotencyToken;

    private NotifyProvisionProductEngineWorkflowResultRequest(BuilderImpl builder) {
        super(builder);
        this.workflowToken = builder.workflowToken;
        this.recordId = builder.recordId;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.outputs = builder.outputs;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String workflowToken() {
        return this.workflowToken;
    }

    public final String recordId() {
        return this.recordId;
    }

    public final EngineWorkflowStatus status() {
        return EngineWorkflowStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final EngineWorkflowResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<RecordOutput> outputs() {
        return this.outputs;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyProvisionProductEngineWorkflowResultRequest)) {
            return false;
        }
        NotifyProvisionProductEngineWorkflowResultRequest other = (NotifyProvisionProductEngineWorkflowResultRequest)((Object)obj);
        return Objects.equals(this.workflowToken(), other.workflowToken()) && Objects.equals(this.recordId(), other.recordId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyProvisionProductEngineWorkflowResultRequest").add("WorkflowToken", (Object)this.workflowToken()).add("RecordId", (Object)this.recordId()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowToken": {
                return Optional.ofNullable(clazz.cast(this.workflowToken()));
            }
            case "RecordId": {
                return Optional.ofNullable(clazz.cast(this.recordId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WorkflowToken", WORKFLOW_TOKEN_FIELD);
        map.put("RecordId", RECORD_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("Outputs", OUTPUTS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotifyProvisionProductEngineWorkflowResultRequest, T> g) {
        return obj -> g.apply((NotifyProvisionProductEngineWorkflowResultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String workflowToken;
        private String recordId;
        private String status;
        private String failureReason;
        private EngineWorkflowResourceIdentifier resourceIdentifier;
        private List<RecordOutput> outputs = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyProvisionProductEngineWorkflowResultRequest model) {
            super(model);
            this.workflowToken(model.workflowToken);
            this.recordId(model.recordId);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.resourceIdentifier(model.resourceIdentifier);
            this.outputs(model.outputs);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getWorkflowToken() {
            return this.workflowToken;
        }

        public final void setWorkflowToken(String workflowToken) {
            this.workflowToken = workflowToken;
        }

        @Override
        public final Builder workflowToken(String workflowToken) {
            this.workflowToken = workflowToken;
            return this;
        }

        public final String getRecordId() {
            return this.recordId;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EngineWorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final EngineWorkflowResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        public final void setResourceIdentifier(EngineWorkflowResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        @Override
        public final Builder resourceIdentifier(EngineWorkflowResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final List<RecordOutput.Builder> getOutputs() {
            List<RecordOutput.Builder> result = RecordOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<RecordOutput.BuilderImpl> outputs) {
            this.outputs = RecordOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<RecordOutput> outputs) {
            this.outputs = RecordOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(RecordOutput ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<RecordOutput.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (RecordOutput)((RecordOutput.Builder)RecordOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyProvisionProductEngineWorkflowResultRequest build() {
            return new NotifyProvisionProductEngineWorkflowResultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, NotifyProvisionProductEngineWorkflowResultRequest> {
        public Builder workflowToken(String var1);

        public Builder recordId(String var1);

        public Builder status(String var1);

        public Builder status(EngineWorkflowStatus var1);

        public Builder failureReason(String var1);

        public Builder resourceIdentifier(EngineWorkflowResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<EngineWorkflowResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((EngineWorkflowResourceIdentifier)((EngineWorkflowResourceIdentifier.Builder)EngineWorkflowResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }

        public Builder outputs(Collection<RecordOutput> var1);

        public Builder outputs(RecordOutput ... var1);

        public Builder outputs(Consumer<RecordOutput.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

