/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConstraintResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeConstraintResponse> {
    private static final SdkField<ConstraintDetail> CONSTRAINT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeConstraintResponse.getter(DescribeConstraintResponse::constraintDetail)).setter(DescribeConstraintResponse.setter(Builder::constraintDetail)).constructor(ConstraintDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintDetail").build()}).build();
    private static final SdkField<String> CONSTRAINT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConstraintResponse.getter(DescribeConstraintResponse::constraintParameters)).setter(DescribeConstraintResponse.setter(Builder::constraintParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintParameters").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConstraintResponse.getter(DescribeConstraintResponse::statusAsString)).setter(DescribeConstraintResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINT_DETAIL_FIELD, CONSTRAINT_PARAMETERS_FIELD, STATUS_FIELD));
    private final ConstraintDetail constraintDetail;
    private final String constraintParameters;
    private final String status;

    private DescribeConstraintResponse(BuilderImpl builder) {
        super(builder);
        this.constraintDetail = builder.constraintDetail;
        this.constraintParameters = builder.constraintParameters;
        this.status = builder.status;
    }

    public ConstraintDetail constraintDetail() {
        return this.constraintDetail;
    }

    public String constraintParameters() {
        return this.constraintParameters;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConstraintResponse)) {
            return false;
        }
        DescribeConstraintResponse other = (DescribeConstraintResponse)((Object)obj);
        return Objects.equals(this.constraintDetail(), other.constraintDetail()) && Objects.equals(this.constraintParameters(), other.constraintParameters()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConstraintResponse").add("ConstraintDetail", (Object)this.constraintDetail()).add("ConstraintParameters", (Object)this.constraintParameters()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstraintDetail": {
                return Optional.ofNullable(clazz.cast(this.constraintDetail()));
            }
            case "ConstraintParameters": {
                return Optional.ofNullable(clazz.cast(this.constraintParameters()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConstraintResponse, T> g) {
        return obj -> g.apply((DescribeConstraintResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ConstraintDetail constraintDetail;
        private String constraintParameters;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConstraintResponse model) {
            super(model);
            this.constraintDetail(model.constraintDetail);
            this.constraintParameters(model.constraintParameters);
            this.status(model.status);
        }

        public final ConstraintDetail.Builder getConstraintDetail() {
            return this.constraintDetail != null ? this.constraintDetail.toBuilder() : null;
        }

        @Override
        public final Builder constraintDetail(ConstraintDetail constraintDetail) {
            this.constraintDetail = constraintDetail;
            return this;
        }

        public final void setConstraintDetail(ConstraintDetail.BuilderImpl constraintDetail) {
            this.constraintDetail = constraintDetail != null ? constraintDetail.build() : null;
        }

        public final String getConstraintParameters() {
            return this.constraintParameters;
        }

        @Override
        public final Builder constraintParameters(String constraintParameters) {
            this.constraintParameters = constraintParameters;
            return this;
        }

        public final void setConstraintParameters(String constraintParameters) {
            this.constraintParameters = constraintParameters;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public DescribeConstraintResponse build() {
            return new DescribeConstraintResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConstraintResponse> {
        public Builder constraintDetail(ConstraintDetail var1);

        default public Builder constraintDetail(Consumer<ConstraintDetail.Builder> constraintDetail) {
            return this.constraintDetail((ConstraintDetail)((ConstraintDetail.Builder)ConstraintDetail.builder().applyMutation(constraintDetail)).build());
        }

        public Builder constraintParameters(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

