/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.AccessLevelFilter;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisionedProductPlansRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, ListProvisionedProductPlansRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProvisionedProductPlansRequest.getter(ListProvisionedProductPlansRequest::acceptLanguage)).setter(ListProvisionedProductPlansRequest.setter(Builder::acceptLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()}).build();
    private static final SdkField<String> PROVISION_PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProvisionedProductPlansRequest.getter(ListProvisionedProductPlansRequest::provisionProductId)).setter(ListProvisionedProductPlansRequest.setter(Builder::provisionProductId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionProductId").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListProvisionedProductPlansRequest.getter(ListProvisionedProductPlansRequest::pageSize)).setter(ListProvisionedProductPlansRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListProvisionedProductPlansRequest.getter(ListProvisionedProductPlansRequest::pageToken)).setter(ListProvisionedProductPlansRequest.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final SdkField<AccessLevelFilter> ACCESS_LEVEL_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ListProvisionedProductPlansRequest.getter(ListProvisionedProductPlansRequest::accessLevelFilter)).setter(ListProvisionedProductPlansRequest.setter(Builder::accessLevelFilter)).constructor(AccessLevelFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLevelFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD, PROVISION_PRODUCT_ID_FIELD, PAGE_SIZE_FIELD, PAGE_TOKEN_FIELD, ACCESS_LEVEL_FILTER_FIELD));
    private final String acceptLanguage;
    private final String provisionProductId;
    private final Integer pageSize;
    private final String pageToken;
    private final AccessLevelFilter accessLevelFilter;

    private ListProvisionedProductPlansRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.provisionProductId = builder.provisionProductId;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
        this.accessLevelFilter = builder.accessLevelFilter;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String provisionProductId() {
        return this.provisionProductId;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public AccessLevelFilter accessLevelFilter() {
        return this.accessLevelFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionProductId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLevelFilter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedProductPlansRequest)) {
            return false;
        }
        ListProvisionedProductPlansRequest other = (ListProvisionedProductPlansRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.provisionProductId(), other.provisionProductId()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.accessLevelFilter(), other.accessLevelFilter());
    }

    public String toString() {
        return ToString.builder((String)"ListProvisionedProductPlansRequest").add("AcceptLanguage", (Object)this.acceptLanguage()).add("ProvisionProductId", (Object)this.provisionProductId()).add("PageSize", (Object)this.pageSize()).add("PageToken", (Object)this.pageToken()).add("AccessLevelFilter", (Object)this.accessLevelFilter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.ofNullable(clazz.cast(this.acceptLanguage()));
            }
            case "ProvisionProductId": {
                return Optional.ofNullable(clazz.cast(this.provisionProductId()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
            case "AccessLevelFilter": {
                return Optional.ofNullable(clazz.cast(this.accessLevelFilter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProvisionedProductPlansRequest, T> g) {
        return obj -> g.apply((ListProvisionedProductPlansRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String provisionProductId;
        private Integer pageSize;
        private String pageToken;
        private AccessLevelFilter accessLevelFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedProductPlansRequest model) {
            super(model);
            this.acceptLanguage(model.acceptLanguage);
            this.provisionProductId(model.provisionProductId);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
            this.accessLevelFilter(model.accessLevelFilter);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getProvisionProductId() {
            return this.provisionProductId;
        }

        @Override
        public final Builder provisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
            return this;
        }

        public final void setProvisionProductId(String provisionProductId) {
            this.provisionProductId = provisionProductId;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final AccessLevelFilter.Builder getAccessLevelFilter() {
            return this.accessLevelFilter != null ? this.accessLevelFilter.toBuilder() : null;
        }

        @Override
        public final Builder accessLevelFilter(AccessLevelFilter accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter;
            return this;
        }

        public final void setAccessLevelFilter(AccessLevelFilter.BuilderImpl accessLevelFilter) {
            this.accessLevelFilter = accessLevelFilter != null ? accessLevelFilter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProvisionedProductPlansRequest build() {
            return new ListProvisionedProductPlansRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProvisionedProductPlansRequest> {
        public Builder acceptLanguage(String var1);

        public Builder provisionProductId(String var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);

        public Builder accessLevelFilter(AccessLevelFilter var1);

        default public Builder accessLevelFilter(Consumer<AccessLevelFilter.Builder> accessLevelFilter) {
            return this.accessLevelFilter((AccessLevelFilter)((AccessLevelFilter.Builder)AccessLevelFilter.builder().applyMutation(accessLevelFilter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

