/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;

public class ListLaunchPathsPublisher
implements SdkPublisher<ListLaunchPathsResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListLaunchPathsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLaunchPathsPublisher(ServiceCatalogAsyncClient client, ListLaunchPathsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLaunchPathsPublisher(ServiceCatalogAsyncClient client, ListLaunchPathsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLaunchPathsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLaunchPathsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListLaunchPathsPublisher resume(ListLaunchPathsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListLaunchPathsPublisher(this.client, (ListLaunchPathsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListLaunchPathsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListLaunchPathsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListLaunchPathsResponseFetcher
    implements AsyncPageFetcher<ListLaunchPathsResponse> {
        private ListLaunchPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListLaunchPathsResponse> nextPage(ListLaunchPathsResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchPathsPublisher.this.client.listLaunchPaths(ListLaunchPathsPublisher.this.firstRequest);
            }
            return ListLaunchPathsPublisher.this.client.listLaunchPaths((ListLaunchPathsRequest)((Object)ListLaunchPathsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

