/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetail;
import software.amazon.awssdk.services.servicecatalog.model.TagOptionDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagOptionsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListTagOptionsResponse> {
    private static final SdkField<List<TagOptionDetail>> TAG_OPTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTagOptionsResponse.getter(ListTagOptionsResponse::tagOptionDetails)).setter(ListTagOptionsResponse.setter(Builder::tagOptionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagOptionDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagOptionDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTagOptionsResponse.getter(ListTagOptionsResponse::pageToken)).setter(ListTagOptionsResponse.setter(Builder::pageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_OPTION_DETAILS_FIELD, PAGE_TOKEN_FIELD));
    private final List<TagOptionDetail> tagOptionDetails;
    private final String pageToken;

    private ListTagOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.tagOptionDetails = builder.tagOptionDetails;
        this.pageToken = builder.pageToken;
    }

    public List<TagOptionDetail> tagOptionDetails() {
        return this.tagOptionDetails;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagOptionsResponse)) {
            return false;
        }
        ListTagOptionsResponse other = (ListTagOptionsResponse)((Object)obj);
        return Objects.equals(this.tagOptionDetails(), other.tagOptionDetails()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTagOptionsResponse").add("TagOptionDetails", this.tagOptionDetails()).add("PageToken", (Object)this.pageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagOptionDetails": {
                return Optional.ofNullable(clazz.cast(this.tagOptionDetails()));
            }
            case "PageToken": {
                return Optional.ofNullable(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagOptionsResponse, T> g) {
        return obj -> g.apply((ListTagOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<TagOptionDetail> tagOptionDetails = DefaultSdkAutoConstructList.getInstance();
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagOptionsResponse model) {
            super(model);
            this.tagOptionDetails(model.tagOptionDetails);
            this.pageToken(model.pageToken);
        }

        public final Collection<TagOptionDetail.Builder> getTagOptionDetails() {
            return this.tagOptionDetails != null ? (Collection)this.tagOptionDetails.stream().map(TagOptionDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagOptionDetails(Collection<TagOptionDetail> tagOptionDetails) {
            this.tagOptionDetails = TagOptionDetailsCopier.copy(tagOptionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptionDetails(TagOptionDetail ... tagOptionDetails) {
            this.tagOptionDetails(Arrays.asList(tagOptionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagOptionDetails(Consumer<TagOptionDetail.Builder> ... tagOptionDetails) {
            this.tagOptionDetails(Stream.of(tagOptionDetails).map(c -> (TagOptionDetail)((TagOptionDetail.Builder)TagOptionDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagOptionDetails(Collection<TagOptionDetail.BuilderImpl> tagOptionDetails) {
            this.tagOptionDetails = TagOptionDetailsCopier.copyFromBuilder(tagOptionDetails);
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public ListTagOptionsResponse build() {
            return new ListTagOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagOptionsResponse> {
        public Builder tagOptionDetails(Collection<TagOptionDetail> var1);

        public Builder tagOptionDetails(TagOptionDetail ... var1);

        public Builder tagOptionDetails(Consumer<TagOptionDetail.Builder> ... var1);

        public Builder pageToken(String var1);
    }
}

