/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListTagOptionsResponse;

public class ListTagOptionsPublisher
implements SdkPublisher<ListTagOptionsResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListTagOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTagOptionsPublisher(ServiceCatalogAsyncClient client, ListTagOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTagOptionsPublisher(ServiceCatalogAsyncClient client, ListTagOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTagOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTagOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListTagOptionsPublisher resume(ListTagOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTagOptionsPublisher(this.client, (ListTagOptionsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.pageToken()).build()));
        }
        return new ListTagOptionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListTagOptionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListTagOptionsResponseFetcher
    implements AsyncPageFetcher<ListTagOptionsResponse> {
        private ListTagOptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.pageToken());
        }

        public CompletableFuture<ListTagOptionsResponse> nextPage(ListTagOptionsResponse previousPage) {
            if (previousPage == null) {
                return ListTagOptionsPublisher.this.client.listTagOptions(ListTagOptionsPublisher.this.firstRequest);
            }
            return ListTagOptionsPublisher.this.client.listTagOptions((ListTagOptionsRequest)((Object)ListTagOptionsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.pageToken()).build()));
        }
    }
}

