/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListLaunchPathsResponse;

public class ListLaunchPathsIterable
implements SdkIterable<ListLaunchPathsResponse> {
    private final ServiceCatalogClient client;
    private final ListLaunchPathsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLaunchPathsIterable(ServiceCatalogClient client, ListLaunchPathsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLaunchPathsResponseFetcher();
    }

    public Iterator<ListLaunchPathsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLaunchPathsResponseFetcher
    implements SyncPageFetcher<ListLaunchPathsResponse> {
        private ListLaunchPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListLaunchPathsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListLaunchPathsResponse nextPage(ListLaunchPathsResponse previousPage) {
            if (previousPage == null) {
                return ListLaunchPathsIterable.this.client.listLaunchPaths(ListLaunchPathsIterable.this.firstRequest);
            }
            return ListLaunchPathsIterable.this.client.listLaunchPaths((ListLaunchPathsRequest)((Object)ListLaunchPathsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

