/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PropertyKey {
    OWNER("OWNER"),
    LAUNCH_ROLE("LAUNCH_ROLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PropertyKey> VALUE_MAP;
    private final String value;

    private PropertyKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PropertyKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PropertyKey> knownValues() {
        EnumSet<PropertyKey> knownValues = EnumSet.allOf(PropertyKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PropertyKey.class, PropertyKey::toString);
    }
}

