/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.DescribePortfolioSharesResponse;

public class DescribePortfolioSharesPublisher
implements SdkPublisher<DescribePortfolioSharesResponse> {
    private final ServiceCatalogAsyncClient client;
    private final DescribePortfolioSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePortfolioSharesPublisher(ServiceCatalogAsyncClient client, DescribePortfolioSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePortfolioSharesPublisher(ServiceCatalogAsyncClient client, DescribePortfolioSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePortfolioSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePortfolioSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribePortfolioSharesResponseFetcher
    implements AsyncPageFetcher<DescribePortfolioSharesResponse> {
        private DescribePortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePortfolioSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<DescribePortfolioSharesResponse> nextPage(DescribePortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return DescribePortfolioSharesPublisher.this.client.describePortfolioShares(DescribePortfolioSharesPublisher.this.firstRequest);
            }
            return DescribePortfolioSharesPublisher.this.client.describePortfolioShares((DescribePortfolioSharesRequest)((Object)DescribePortfolioSharesPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

