/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListBudgetsForResourceResponse;

public class ListBudgetsForResourcePublisher
implements SdkPublisher<ListBudgetsForResourceResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListBudgetsForResourceRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBudgetsForResourcePublisher(ServiceCatalogAsyncClient client, ListBudgetsForResourceRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBudgetsForResourcePublisher(ServiceCatalogAsyncClient client, ListBudgetsForResourceRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBudgetsForResourceResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBudgetsForResourceResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBudgetsForResourceResponseFetcher
    implements AsyncPageFetcher<ListBudgetsForResourceResponse> {
        private ListBudgetsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListBudgetsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListBudgetsForResourceResponse> nextPage(ListBudgetsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListBudgetsForResourcePublisher.this.client.listBudgetsForResource(ListBudgetsForResourcePublisher.this.firstRequest);
            }
            return ListBudgetsForResourcePublisher.this.client.listBudgetsForResource((ListBudgetsForResourceRequest)((Object)ListBudgetsForResourcePublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

