/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.OrganizationNode;
import software.amazon.awssdk.services.servicecatalog.model.OrganizationNodesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationPortfolioAccessResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListOrganizationPortfolioAccessResponse> {
    private static final SdkField<List<OrganizationNode>> ORGANIZATION_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListOrganizationPortfolioAccessResponse.getter(ListOrganizationPortfolioAccessResponse::organizationNodes)).setter(ListOrganizationPortfolioAccessResponse.setter(Builder::organizationNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListOrganizationPortfolioAccessResponse.getter(ListOrganizationPortfolioAccessResponse::nextPageToken)).setter(ListOrganizationPortfolioAccessResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_NODES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<OrganizationNode> organizationNodes;
    private final String nextPageToken;

    private ListOrganizationPortfolioAccessResponse(BuilderImpl builder) {
        super(builder);
        this.organizationNodes = builder.organizationNodes;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasOrganizationNodes() {
        return this.organizationNodes != null && !(this.organizationNodes instanceof SdkAutoConstructList);
    }

    public List<OrganizationNode> organizationNodes() {
        return this.organizationNodes;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationPortfolioAccessResponse)) {
            return false;
        }
        ListOrganizationPortfolioAccessResponse other = (ListOrganizationPortfolioAccessResponse)((Object)obj);
        return Objects.equals(this.organizationNodes(), other.organizationNodes()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListOrganizationPortfolioAccessResponse").add("OrganizationNodes", this.organizationNodes()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationNodes": {
                return Optional.ofNullable(clazz.cast(this.organizationNodes()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationPortfolioAccessResponse, T> g) {
        return obj -> g.apply((ListOrganizationPortfolioAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<OrganizationNode> organizationNodes = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationPortfolioAccessResponse model) {
            super(model);
            this.organizationNodes(model.organizationNodes);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<OrganizationNode.Builder> getOrganizationNodes() {
            return this.organizationNodes != null ? (Collection)this.organizationNodes.stream().map(OrganizationNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder organizationNodes(Collection<OrganizationNode> organizationNodes) {
            this.organizationNodes = OrganizationNodesCopier.copy(organizationNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationNodes(OrganizationNode ... organizationNodes) {
            this.organizationNodes(Arrays.asList(organizationNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationNodes(Consumer<OrganizationNode.Builder> ... organizationNodes) {
            this.organizationNodes(Stream.of(organizationNodes).map(c -> (OrganizationNode)((OrganizationNode.Builder)OrganizationNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationNodes(Collection<OrganizationNode.BuilderImpl> organizationNodes) {
            this.organizationNodes = OrganizationNodesCopier.copyFromBuilder(organizationNodes);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListOrganizationPortfolioAccessResponse build() {
            return new ListOrganizationPortfolioAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationPortfolioAccessResponse> {
        public Builder organizationNodes(Collection<OrganizationNode> var1);

        public Builder organizationNodes(OrganizationNode ... var1);

        public Builder organizationNodes(Consumer<OrganizationNode.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

