/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductViewDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductViewDetail> {
    private static final SdkField<ProductViewSummary> PRODUCT_VIEW_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ProductViewDetail.getter(ProductViewDetail::productViewSummary)).setter(ProductViewDetail.setter(Builder::productViewSummary)).constructor(ProductViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductViewSummary").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductViewDetail.getter(ProductViewDetail::statusAsString)).setter(ProductViewDetail.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductViewDetail.getter(ProductViewDetail::productARN)).setter(ProductViewDetail.setter(Builder::productARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductARN").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ProductViewDetail.getter(ProductViewDetail::createdTime)).setter(ProductViewDetail.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_VIEW_SUMMARY_FIELD, STATUS_FIELD, PRODUCT_ARN_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final ProductViewSummary productViewSummary;
    private final String status;
    private final String productARN;
    private final Instant createdTime;

    private ProductViewDetail(BuilderImpl builder) {
        this.productViewSummary = builder.productViewSummary;
        this.status = builder.status;
        this.productARN = builder.productARN;
        this.createdTime = builder.createdTime;
    }

    public ProductViewSummary productViewSummary() {
        return this.productViewSummary;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String productARN() {
        return this.productARN;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductViewDetail)) {
            return false;
        }
        ProductViewDetail other = (ProductViewDetail)obj;
        return Objects.equals(this.productViewSummary(), other.productViewSummary()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.productARN(), other.productARN()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"ProductViewDetail").add("ProductViewSummary", (Object)this.productViewSummary()).add("Status", (Object)this.statusAsString()).add("ProductARN", (Object)this.productARN()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummary": {
                return Optional.ofNullable(clazz.cast(this.productViewSummary()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ProductARN": {
                return Optional.ofNullable(clazz.cast(this.productARN()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductViewDetail, T> g) {
        return obj -> g.apply((ProductViewDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProductViewSummary productViewSummary;
        private String status;
        private String productARN;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductViewDetail model) {
            this.productViewSummary(model.productViewSummary);
            this.status(model.status);
            this.productARN(model.productARN);
            this.createdTime(model.createdTime);
        }

        public final ProductViewSummary.Builder getProductViewSummary() {
            return this.productViewSummary != null ? this.productViewSummary.toBuilder() : null;
        }

        @Override
        public final Builder productViewSummary(ProductViewSummary productViewSummary) {
            this.productViewSummary = productViewSummary;
            return this;
        }

        public final void setProductViewSummary(ProductViewSummary.BuilderImpl productViewSummary) {
            this.productViewSummary = productViewSummary != null ? productViewSummary.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getProductARN() {
            return this.productARN;
        }

        @Override
        public final Builder productARN(String productARN) {
            this.productARN = productARN;
            return this;
        }

        public final void setProductARN(String productARN) {
            this.productARN = productARN;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public ProductViewDetail build() {
            return new ProductViewDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductViewDetail> {
        public Builder productViewSummary(ProductViewSummary var1);

        default public Builder productViewSummary(Consumer<ProductViewSummary.Builder> productViewSummary) {
            return this.productViewSummary((ProductViewSummary)((ProductViewSummary.Builder)ProductViewSummary.builder().applyMutation(productViewSummary)).build());
        }

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder productARN(String var1);

        public Builder createdTime(Instant var1);
    }
}

