/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;

public abstract class AwsIntegrationTestBase {
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-test-account";
    public static final AwsCredentialsProviderChain CREDENTIALS_PROVIDER_CHAIN = AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{ProfileCredentialsProvider.builder().profileName("aws-test-account").build(), DefaultCredentialsProvider.create()});
    private static final AwsCredentials CREDENTIALS = CREDENTIALS_PROVIDER_CHAIN.resolveCredentials();

    @Deprecated
    protected static AwsCredentials getCredentials() {
        return CREDENTIALS;
    }

    protected static AwsCredentialsProvider getCredentialsProvider() {
        return StaticCredentialsProvider.create((AwsCredentials)CREDENTIALS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResourceAsString(Class<?> clazz, String location) {
        try (InputStream resourceStream = clazz.getResourceAsStream(location);){
            String resourceAsString = IoUtils.toUtf8String((InputStream)resourceStream);
            resourceStream.close();
            String string = resourceAsString;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

