/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service;

import java.io.IOException;
import java.io.InputStream;
import reactor.blockhound.BlockHound;
import reactor.blockhound.integration.BlockHoundIntegration;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.utils.IoUtils;

public abstract class AwsIntegrationTestBase {
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-test-account";
    public static final AwsCredentialsProviderChain CREDENTIALS_PROVIDER_CHAIN;
    private static final AwsCredentials CREDENTIALS;

    @Deprecated
    protected static AwsCredentials getCredentials() {
        return CREDENTIALS;
    }

    protected static IdentityProvider<AwsCredentialsIdentity> getCredentialsProvider() {
        return StaticCredentialsProvider.create((AwsCredentials)CREDENTIALS);
    }

    protected String getResourceAsString(Class<?> clazz, String location) {
        String string;
        block8: {
            InputStream resourceStream = clazz.getResourceAsStream(location);
            try {
                String resourceAsString = IoUtils.toUtf8String((InputStream)resourceStream);
                resourceStream.close();
                string = resourceAsString;
                if (resourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            resourceStream.close();
        }
        return string;
    }

    static {
        BlockHound.install((BlockHoundIntegration[])new BlockHoundIntegration[0]);
        CREDENTIALS_PROVIDER_CHAIN = AwsCredentialsProviderChain.of((AwsCredentialsProvider[])new AwsCredentialsProvider[]{ProfileCredentialsProvider.builder().profileName(TEST_CREDENTIALS_PROFILE_NAME).build(), DefaultCredentialsProvider.create()});
        CREDENTIALS = CREDENTIALS_PROVIDER_CHAIN.resolveCredentials();
    }
}

