/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.testutils.service.http.MockHttpClient;

public final class MockSyncHttpClient
implements SdkHttpClient,
MockHttpClient {
    private final List<SdkHttpRequest> capturedRequests = new ArrayList<SdkHttpRequest>();
    private final List<HttpExecuteResponse> responses = new LinkedList<HttpExecuteResponse>();
    private final AtomicInteger responseIndex = new AtomicInteger(0);

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        this.capturedRequests.add(request.httpRequest());
        return new ExecutableHttpRequest(){

            public HttpExecuteResponse call() {
                HttpExecuteResponse response = (HttpExecuteResponse)MockSyncHttpClient.this.responses.get(MockSyncHttpClient.this.responseIndex.getAndIncrement() % MockSyncHttpClient.this.responses.size());
                if (response == null) {
                    throw new IllegalStateException("No responses remain.");
                }
                return response;
            }

            public void abort() {
            }
        };
    }

    public void close() {
    }

    @Override
    public void reset() {
        this.capturedRequests.clear();
        this.responses.clear();
        this.responseIndex.set(0);
    }

    @Override
    public void stubNextResponse(HttpExecuteResponse nextResponse) {
        this.responses.clear();
        this.responses.add(nextResponse);
        this.responseIndex.set(0);
    }

    @Override
    public void stubResponses(HttpExecuteResponse ... responses) {
        this.responses.clear();
        this.responses.addAll(Arrays.asList(responses));
        this.responseIndex.set(0);
    }

    @Override
    public List<SdkHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.capturedRequests);
    }

    @Override
    public SdkHttpRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }
}

