/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;

public final class MockAyncHttpClient
implements SdkAsyncHttpClient {
    private final List<SdkHttpRequest> capturedRequests = new ArrayList<SdkHttpRequest>();
    private HttpExecuteResponse nextResponse;

    public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
        this.capturedRequests.add(request.request());
        request.responseHandler().onHeaders(this.nextResponse.httpResponse());
        request.responseHandler().onStream((Publisher)new SdkHttpContentPublisher(){
            byte[] content;
            {
                this.content = MockAyncHttpClient.this.nextResponse.responseBody().map(p -> (byte[])FunctionalUtils.invokeSafely(() -> IoUtils.toByteArray((InputStream)p))).orElseGet(() -> new byte[0]);
            }

            public Optional<Long> contentLength() {
                return Optional.of(Long.valueOf(this.content.length));
            }

            public void subscribe(final Subscriber<? super ByteBuffer> s) {
                s.onSubscribe(new Subscription(){
                    private boolean running = true;

                    public void request(long n) {
                        if (n <= 0L) {
                            this.running = false;
                            s.onError((Throwable)new IllegalArgumentException("Demand must be positive"));
                        } else if (this.running) {
                            this.running = false;
                            s.onNext((Object)ByteBuffer.wrap(content));
                            s.onComplete();
                        }
                    }

                    public void cancel() {
                        this.running = false;
                    }
                });
            }
        });
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
    }

    public void reset() {
        this.capturedRequests.clear();
        this.nextResponse = null;
    }

    public SdkHttpRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }

    public void stubNextResponse(HttpExecuteResponse nextResponse) {
        this.nextResponse = nextResponse;
    }
}

