/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.http.ExecutableHttpRequest;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpRequest;

public final class MockHttpClient
implements SdkHttpClient {
    private final List<SdkHttpRequest> capturedRequests = new ArrayList<SdkHttpRequest>();
    private HttpExecuteResponse nextResponse;

    public ExecutableHttpRequest prepareRequest(HttpExecuteRequest request) {
        this.capturedRequests.add(request.httpRequest());
        return new ExecutableHttpRequest(){

            public HttpExecuteResponse call() {
                return MockHttpClient.this.nextResponse;
            }

            public void abort() {
            }
        };
    }

    public void close() {
    }

    public void reset() {
        this.capturedRequests.clear();
        this.nextResponse = null;
    }

    public void stubNextResponse(HttpExecuteResponse nextResponse) {
        this.nextResponse = nextResponse;
    }

    public SdkHttpRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }
}

